/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bcmdataexports.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.bcmdataexports.model.Export;
import com.amazonaws.services.bcmdataexports.model.ResourceTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateExportRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Export export;
    private List<ResourceTag> resourceTags;

    public void setExport(Export export) {
        this.export = export;
    }

    public Export getExport() {
        return this.export;
    }

    public CreateExportRequest withExport(Export export) {
        this.setExport(export);
        return this;
    }

    public List<ResourceTag> getResourceTags() {
        return this.resourceTags;
    }

    public void setResourceTags(Collection<ResourceTag> resourceTags) {
        if (resourceTags == null) {
            this.resourceTags = null;
            return;
        }
        this.resourceTags = new ArrayList<ResourceTag>(resourceTags);
    }

    public CreateExportRequest withResourceTags(ResourceTag ... resourceTags) {
        if (this.resourceTags == null) {
            this.setResourceTags(new ArrayList<ResourceTag>(resourceTags.length));
        }
        for (ResourceTag ele : resourceTags) {
            this.resourceTags.add(ele);
        }
        return this;
    }

    public CreateExportRequest withResourceTags(Collection<ResourceTag> resourceTags) {
        this.setResourceTags(resourceTags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExport() != null) {
            sb.append("Export: ").append(this.getExport()).append(",");
        }
        if (this.getResourceTags() != null) {
            sb.append("ResourceTags: ").append(this.getResourceTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportRequest)) {
            return false;
        }
        CreateExportRequest other = (CreateExportRequest)obj;
        if (other.getExport() == null ^ this.getExport() == null) {
            return false;
        }
        if (other.getExport() != null && !other.getExport().equals(this.getExport())) {
            return false;
        }
        if (other.getResourceTags() == null ^ this.getResourceTags() == null) {
            return false;
        }
        return other.getResourceTags() == null || other.getResourceTags().equals(this.getResourceTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExport() == null ? 0 : this.getExport().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTags() == null ? 0 : this.getResourceTags().hashCode());
        return hashCode;
    }

    public CreateExportRequest clone() {
        return (CreateExportRequest)super.clone();
    }
}

