/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskType;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;

public class MetricsCollectingTaskDecorator
implements ITask {
    private final ITask other;
    private final IMetricsFactory factory;

    public MetricsCollectingTaskDecorator(ITask other, IMetricsFactory factory) {
        this.other = other;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() {
        MetricsHelper.startScope(this.factory, this.other.getClass().getSimpleName());
        TaskResult result = null;
        long startTimeMillis = System.currentTimeMillis();
        try {
            result = this.other.call();
            MetricsHelper.addSuccessAndLatency(startTimeMillis, result != null && result.getException() == null, MetricsLevel.SUMMARY);
        }
        catch (Throwable throwable) {
            MetricsHelper.addSuccessAndLatency(startTimeMillis, result != null && result.getException() == null, MetricsLevel.SUMMARY);
            MetricsHelper.endScope();
            throw throwable;
        }
        MetricsHelper.endScope();
        return result;
    }

    @Override
    public TaskType getTaskType() {
        return this.other.getTaskType();
    }

    public String toString() {
        return this.getClass().getName() + "<" + (Object)((Object)this.other.getTaskType()) + ">(" + this.other + ")";
    }

    ITask getOther() {
        return this.other;
    }
}

