/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.google.common.annotations.VisibleForTesting;

public interface IPeriodicShardSyncManager {
    public TaskResult start();

    public TaskResult syncShardsOnce();

    public void stop();

    @VisibleForTesting
    public static final class ShardSyncResponse {
        private final boolean shouldDoShardSync;
        private final boolean isHoleDetected;
        private final String reasonForDecision;

        public ShardSyncResponse(boolean shouldDoShardSync, boolean isHoleDetected, String reasonForDecision) {
            this.shouldDoShardSync = shouldDoShardSync;
            this.isHoleDetected = isHoleDetected;
            this.reasonForDecision = reasonForDecision;
        }

        public boolean shouldDoShardSync() {
            return this.shouldDoShardSync;
        }

        public boolean isHoleDetected() {
            return this.isHoleDetected;
        }

        public String reasonForDecision() {
            return this.reasonForDecision;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShardSyncResponse)) {
                return false;
            }
            ShardSyncResponse other = (ShardSyncResponse)o;
            if (this.shouldDoShardSync() != other.shouldDoShardSync()) {
                return false;
            }
            if (this.isHoleDetected() != other.isHoleDetected()) {
                return false;
            }
            String this$reasonForDecision = this.reasonForDecision();
            String other$reasonForDecision = other.reasonForDecision();
            return !(this$reasonForDecision == null ? other$reasonForDecision != null : !this$reasonForDecision.equals(other$reasonForDecision));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.shouldDoShardSync() ? 79 : 97);
            result = result * 59 + (this.isHoleDetected() ? 79 : 97);
            String $reasonForDecision = this.reasonForDecision();
            result = result * 59 + ($reasonForDecision == null ? 43 : $reasonForDecision.hashCode());
            return result;
        }

        public String toString() {
            return "IPeriodicShardSyncManager.ShardSyncResponse(shouldDoShardSync=" + this.shouldDoShardSync() + ", isHoleDetected=" + this.isHoleDetected() + ", reasonForDecision=" + this.reasonForDecision() + ")";
        }
    }
}

