/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services;

import com.amazon.ask.model.services.ApiClient;
import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.Serializer;
import com.amazon.ask.model.services.util.JacksonSerializer;

public class DefaultApiConfiguration
implements ApiConfiguration {
    private static final String DEFAULT_API_ENDPOINT = "https://api.amazonalexa.com";
    private Serializer serializer;
    private ApiClient apiClient;
    private String authorizationValue;
    private String apiEndpoint;

    private DefaultApiConfiguration(Builder builder) {
        this.apiClient = builder.apiClient;
        this.authorizationValue = builder.authorizationValue;
        this.serializer = builder.serializer != null ? builder.serializer : new JacksonSerializer();
        this.apiEndpoint = builder.apiEndpoint != null ? builder.apiEndpoint : DEFAULT_API_ENDPOINT;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ApiClient getApiClient() {
        return this.apiClient;
    }

    @Override
    public String getAuthorizationValue() {
        return this.authorizationValue;
    }

    @Override
    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public static final class Builder {
        private Serializer serializer;
        private ApiClient apiClient;
        private String authorizationValue;
        private String apiEndpoint;

        private Builder() {
        }

        public Builder withSerializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder withApiClient(ApiClient apiClient) {
            this.apiClient = apiClient;
            return this;
        }

        public Builder withAuthorizationValue(String authorizationValue) {
            this.authorizationValue = authorizationValue;
            return this;
        }

        public Builder withApiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        public DefaultApiConfiguration build() {
            return new DefaultApiConfiguration(this);
        }
    }
}

