/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.AbstractGitFlowMojo;
import com.amashchenko.maven.plugin.gitflow.GitFlowVersionInfo;
import java.util.HashMap;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="release-finish", aggregator=true)
public class GitFlowReleaseFinishMojo
extends AbstractGitFlowMojo {
    @Parameter(property="skipTag", defaultValue="false")
    private boolean skipTag = false;
    @Parameter(property="keepBranch", defaultValue="false")
    private boolean keepBranch = false;
    @Parameter(property="skipTestProject", defaultValue="false")
    private boolean skipTestProject = false;
    @Parameter(property="allowSnapshots", defaultValue="false")
    private boolean allowSnapshots = false;
    @Parameter(property="releaseRebase", defaultValue="false")
    private boolean releaseRebase = false;
    @Parameter(property="releaseMergeNoFF", defaultValue="true")
    private boolean releaseMergeNoFF = true;
    @Parameter(property="pushRemote", defaultValue="true")
    private boolean pushRemote;
    @Parameter(property="releaseMergeFFOnly", defaultValue="false")
    private boolean releaseMergeFFOnly = false;
    @Parameter(property="digitsOnlyDevVersion", defaultValue="false")
    private boolean digitsOnlyDevVersion = false;
    @Parameter(property="developmentVersion", defaultValue="")
    private String developmentVersion = "";
    @Parameter(property="versionDigitToIncrement")
    private Integer versionDigitToIncrement;
    @Parameter(property="commitDevelopmentVersionAtStart", defaultValue="false")
    private boolean commitDevelopmentVersionAtStart;
    @Parameter(property="preReleaseGoals")
    private String preReleaseGoals;
    @Parameter(property="postReleaseGoals")
    private String postReleaseGoals;
    @Parameter(property="gpgSignTag", defaultValue="false")
    private boolean gpgSignTag = false;
    @Parameter(property="useSnapshotInRelease", defaultValue="false")
    private boolean useSnapshotInRelease;
    @Parameter(property="skipReleaseMergeProdBranch", defaultValue="false")
    private boolean skipReleaseMergeProdBranch = false;
    @Parameter(property="noBackMerge", defaultValue="false")
    private boolean noBackMerge = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfiguration(this.preReleaseGoals, this.postReleaseGoals);
        try {
            String tagVersion;
            this.checkUncommittedChanges();
            String releaseBranch = this.gitFindBranches(this.gitFlowConfig.getReleaseBranchPrefix(), false);
            if (StringUtils.isBlank((String)releaseBranch)) {
                if (this.fetchRemote) {
                    releaseBranch = this.gitFetchAndFindRemoteBranches(this.gitFlowConfig.getReleaseBranchPrefix(), false);
                    if (StringUtils.isBlank((String)releaseBranch)) {
                        throw new MojoFailureException("There is no remote or local release branch.");
                    }
                    if (StringUtils.countMatches((String)(releaseBranch = releaseBranch.substring(this.gitFlowConfig.getOrigin().length() + 1)), (String)this.gitFlowConfig.getReleaseBranchPrefix()) > 1) {
                        throw new MojoFailureException("More than one remote release branch exists. Cannot finish release.");
                    }
                    this.gitCreateAndCheckout(releaseBranch, this.gitFlowConfig.getOrigin() + "/" + releaseBranch);
                } else {
                    throw new MojoFailureException("There is no release branch.");
                }
            }
            if (StringUtils.countMatches((String)releaseBranch, (String)this.gitFlowConfig.getReleaseBranchPrefix()) > 1) {
                throw new MojoFailureException("More than one release branch exists. Cannot finish release.");
            }
            if (!this.allowSnapshots) {
                this.gitCheckout(releaseBranch);
                this.checkSnapshotDependencies();
            }
            if (this.fetchRemote) {
                this.gitFetchRemoteAndCompareCreate(releaseBranch);
                this.gitFetchRemoteAndCompareCreate(this.gitFlowConfig.getDevelopmentBranch());
                if (this.notSameProdDevName()) {
                    this.gitFetchRemoteAndCompareCreate(this.gitFlowConfig.getProductionBranch());
                }
            }
            this.gitCheckout(releaseBranch);
            if (!this.skipTestProject) {
                this.mvnCleanTest();
            }
            if (StringUtils.isNotBlank((String)this.preReleaseGoals)) {
                this.mvnRun(this.preReleaseGoals);
            }
            String currentReleaseVersion = this.getCurrentProjectVersion();
            HashMap<String, String> messageProperties = new HashMap<String, String>();
            messageProperties.put("version", currentReleaseVersion);
            if (this.useSnapshotInRelease && ArtifactUtils.isSnapshot((String)currentReleaseVersion)) {
                String commitVersion = currentReleaseVersion.replace("-SNAPSHOT", "");
                this.mvnSetVersions(commitVersion);
                messageProperties.put("version", commitVersion);
                this.gitCommit(this.commitMessages.getReleaseFinishMessage(), messageProperties);
            }
            if (!this.skipReleaseMergeProdBranch) {
                this.gitCheckout(this.gitFlowConfig.getProductionBranch());
                this.gitMerge(releaseBranch, this.releaseRebase, this.releaseMergeNoFF, this.releaseMergeFFOnly, this.commitMessages.getReleaseFinishMergeMessage(), messageProperties);
            }
            String currentVersion = this.getCurrentProjectVersion();
            String string = tagVersion = (this.tychoBuild || this.useSnapshotInRelease) && ArtifactUtils.isSnapshot((String)currentVersion) ? currentVersion.replace("-SNAPSHOT", "") : currentVersion;
            if (!this.skipTag) {
                messageProperties.put("version", tagVersion);
                this.gitTag(this.gitFlowConfig.getVersionTagPrefix() + tagVersion, this.commitMessages.getTagReleaseMessage(), this.gpgSignTag, messageProperties);
            }
            if (StringUtils.isNotBlank((String)this.postReleaseGoals)) {
                this.mvnRun(this.postReleaseGoals);
            }
            if (this.notSameProdDevName()) {
                this.gitCheckout(this.gitFlowConfig.getDevelopmentBranch());
                String developReleaseVersion = this.getCurrentProjectVersion();
                if (this.commitDevelopmentVersionAtStart && this.useSnapshotInRelease) {
                    this.mvnSetVersions(currentVersion);
                    this.gitCommit(this.commitMessages.getUpdateDevToAvoidConflictsMessage());
                }
                String refToMerge = this.noBackMerge ? releaseBranch : (!this.skipTag ? this.gitFlowConfig.getVersionTagPrefix() + tagVersion : this.gitFlowConfig.getProductionBranch());
                this.gitMerge(refToMerge, this.releaseRebase, this.releaseMergeNoFF, false, this.commitMessages.getReleaseFinishDevMergeMessage(), messageProperties);
                if (this.commitDevelopmentVersionAtStart && this.useSnapshotInRelease) {
                    this.mvnSetVersions(developReleaseVersion);
                    this.gitCommit(this.commitMessages.getUpdateDevBackPreMergeStateMessage());
                }
            }
            if (this.commitDevelopmentVersionAtStart && !this.notSameProdDevName()) {
                this.getLog().warn((CharSequence)"The commitDevelopmentVersionAtStart will not have effect. It can be enabled only when there are separate branches for development and production.");
                this.commitDevelopmentVersionAtStart = false;
            }
            if (!this.commitDevelopmentVersionAtStart) {
                String nextSnapshotVersion;
                if (!this.settings.isInteractiveMode() && StringUtils.isNotBlank((String)this.developmentVersion)) {
                    nextSnapshotVersion = this.developmentVersion;
                } else {
                    GitFlowVersionInfo versionInfo = new GitFlowVersionInfo(currentVersion, this.getVersionPolicy());
                    if (this.digitsOnlyDevVersion) {
                        versionInfo = versionInfo.digitsVersionInfo();
                    }
                    nextSnapshotVersion = versionInfo.nextSnapshotVersion(this.versionDigitToIncrement);
                }
                if (StringUtils.isBlank((String)nextSnapshotVersion)) {
                    throw new MojoFailureException("Next snapshot version is blank.");
                }
                this.mvnSetVersions(nextSnapshotVersion);
                messageProperties.put("version", nextSnapshotVersion);
                this.gitCommit(this.commitMessages.getReleaseFinishMessage(), messageProperties);
            }
            if (this.installProject) {
                this.mvnCleanInstall();
            }
            if (this.pushRemote) {
                this.gitPush(this.gitFlowConfig.getProductionBranch(), !this.skipTag);
                if (this.notSameProdDevName()) {
                    this.gitPush(this.gitFlowConfig.getDevelopmentBranch(), !this.skipTag);
                }
                if (!this.keepBranch) {
                    this.gitPushDelete(releaseBranch);
                }
            }
            if (!this.keepBranch) {
                this.gitBranchDelete(releaseBranch);
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("release-finish", (Throwable)e);
        }
    }
}

