/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hl7InputStreamMessageStringIterator
implements Iterator<String> {
    private static final Log ourLog = LogFactory.getLog(Hl7InputStreamMessageStringIterator.class);
    private Reader myReader;
    private Boolean myHasNext;
    private String myNext;
    private StringBuilder myBuffer = new StringBuilder();
    private boolean myFoundMessageInBuffer = false;

    public Hl7InputStreamMessageStringIterator(InputStream theInputStream) {
        this(new InputStreamReader(theInputStream));
    }

    public Hl7InputStreamMessageStringIterator(Reader theReader) {
        this.myReader = new PushbackReader(theReader);
    }

    @Override
    public boolean hasNext() {
        if (this.myHasNext == null) {
            String msgString;
            int endOfBuffer = -1;
            while (true) {
                int next;
                try {
                    next = this.myReader.read();
                }
                catch (IOException e) {
                    throw new ParseFailureError("IOException reading from input", e);
                }
                if (next == -1) break;
                char nextChar = (char)next;
                if (nextChar == '\n') {
                    if (this.myBuffer.length() > 0 && this.myBuffer.charAt(this.myBuffer.length() - 1) != '\r') {
                        this.myBuffer.append('\r');
                    }
                } else {
                    this.myBuffer.append(nextChar);
                }
                int bLength = this.myBuffer.length();
                if (nextChar != 'H' || bLength < 3 || this.myBuffer.charAt(bLength - 2) != 'S' || this.myBuffer.charAt(bLength - 3) != 'M') continue;
                if (this.myFoundMessageInBuffer) {
                    if (this.myBuffer.charAt(bLength - 4) >= ' ') continue;
                    endOfBuffer = bLength - 3;
                    break;
                }
                this.myBuffer.delete(0, bLength - 3);
                this.myFoundMessageInBuffer = true;
            }
            if (!this.myFoundMessageInBuffer) {
                this.myHasNext = false;
                return this.myHasNext;
            }
            if (endOfBuffer > -1) {
                msgString = this.myBuffer.substring(0, endOfBuffer);
                this.myBuffer.delete(0, endOfBuffer);
            } else {
                msgString = this.myBuffer.toString();
                this.myBuffer.setLength(0);
            }
            if (!msgString.startsWith("MSH")) {
                this.myHasNext = Boolean.FALSE;
                return this.myHasNext;
            }
            this.myNext = msgString;
            this.myHasNext = Boolean.TRUE;
        }
        return this.myHasNext;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new IllegalStateException();
        }
        String retVal = this.myNext;
        this.myNext = null;
        this.myHasNext = null;
        return retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class ParseFailureError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseFailureError(String theMessage, Exception theCause) {
            super(theMessage, theCause);
        }
    }
}

