/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.internal.batchmanager.IdentifiableMessage;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestBatchConfiguration;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestBatchManager;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.services.sqs.model.SqsException;
import software.amazon.awssdk.utils.Either;

@SdkInternalApi
public class SendMessageBatchManager
extends RequestBatchManager<SendMessageRequest, SendMessageResponse, SendMessageBatchResponse> {
    private final SqsAsyncClient asyncClient;

    protected SendMessageBatchManager(RequestBatchConfiguration overrideConfiguration, ScheduledExecutorService scheduledExecutor, SqsAsyncClient asyncClient) {
        super(overrideConfiguration, scheduledExecutor);
        this.asyncClient = asyncClient;
    }

    private static IdentifiableMessage<Throwable> sendMessageCreateThrowable(BatchResultErrorEntry failedEntry) {
        String key = failedEntry.id();
        AwsErrorDetails errorDetailsBuilder = AwsErrorDetails.builder().errorCode(failedEntry.code()).errorMessage(failedEntry.message()).build();
        AwsServiceException response = SqsException.builder().awsErrorDetails(errorDetailsBuilder).build();
        return new IdentifiableMessage<AwsServiceException>(key, response);
    }

    private static IdentifiableMessage<SendMessageResponse> createSendMessageResponse(SendMessageBatchResultEntry successfulEntry, SendMessageBatchResponse batchResponse) {
        String key = successfulEntry.id();
        SendMessageResponse.Builder builder = SendMessageResponse.builder().md5OfMessageBody(successfulEntry.md5OfMessageBody()).md5OfMessageAttributes(successfulEntry.md5OfMessageAttributes()).md5OfMessageSystemAttributes(successfulEntry.md5OfMessageSystemAttributes()).messageId(successfulEntry.messageId()).sequenceNumber(successfulEntry.sequenceNumber());
        if (batchResponse.responseMetadata() != null) {
            builder.responseMetadata(batchResponse.responseMetadata());
        }
        if (batchResponse.sdkHttpResponse() != null) {
            builder.sdkHttpResponse(batchResponse.sdkHttpResponse());
        }
        SendMessageResponse response = (SendMessageResponse)((Object)builder.build());
        return new IdentifiableMessage<SendMessageResponse>(key, response);
    }

    private static SendMessageBatchRequest createSendMessageBatchRequest(List<IdentifiableMessage<SendMessageRequest>> identifiedRequests, String batchKey) {
        List entries = identifiedRequests.stream().map(identifiedRequest -> SendMessageBatchManager.createSendMessageBatchRequestEntry(identifiedRequest.id(), (SendMessageRequest)((Object)((Object)identifiedRequest.message())))).collect(Collectors.toList());
        Optional overrideConfiguration = identifiedRequests.get(0).message().overrideConfiguration();
        return overrideConfiguration.map(overrideConfig -> (SendMessageBatchRequest)((Object)((Object)SendMessageBatchRequest.builder().queueUrl(batchKey).overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)overrideConfig.toBuilder().applyMutation(USER_AGENT_APPLIER)).build()).entries(entries).build()))).orElseGet(() -> (SendMessageBatchRequest)((Object)((Object)SendMessageBatchRequest.builder().queueUrl(batchKey).overrideConfiguration(o -> o.applyMutation(USER_AGENT_APPLIER)).entries(entries).build())));
    }

    private static SendMessageBatchRequestEntry createSendMessageBatchRequestEntry(String id, SendMessageRequest request) {
        return (SendMessageBatchRequestEntry)SendMessageBatchRequestEntry.builder().id(id).messageBody(request.messageBody()).delaySeconds(request.delaySeconds()).messageAttributes(request.messageAttributes()).messageSystemAttributesWithStrings(request.messageSystemAttributesAsStrings()).messageDeduplicationId(request.messageDeduplicationId()).messageGroupId(request.messageGroupId()).build();
    }

    @Override
    protected CompletableFuture<SendMessageBatchResponse> batchAndSend(List<IdentifiableMessage<SendMessageRequest>> identifiedRequests, String batchKey) {
        SendMessageBatchRequest batchRequest = SendMessageBatchManager.createSendMessageBatchRequest(identifiedRequests, batchKey);
        return this.asyncClient.sendMessageBatch(batchRequest);
    }

    @Override
    protected String getBatchKey(SendMessageRequest request) {
        return request.overrideConfiguration().map(overrideConfig -> request.queueUrl() + overrideConfig.hashCode()).orElseGet(request::queueUrl);
    }

    @Override
    protected List<Either<IdentifiableMessage<SendMessageResponse>, IdentifiableMessage<Throwable>>> mapBatchResponse(SendMessageBatchResponse batchResponse) {
        ArrayList<Either<IdentifiableMessage<SendMessageResponse>, IdentifiableMessage<Throwable>>> mappedResponses = new ArrayList<Either<IdentifiableMessage<SendMessageResponse>, IdentifiableMessage<Throwable>>>();
        batchResponse.successful().forEach(batchResponseEntry -> {
            IdentifiableMessage<SendMessageResponse> response = SendMessageBatchManager.createSendMessageResponse(batchResponseEntry, batchResponse);
            mappedResponses.add(Either.left(response));
        });
        batchResponse.failed().forEach(batchResponseEntry -> {
            IdentifiableMessage<Throwable> response = SendMessageBatchManager.sendMessageCreateThrowable(batchResponseEntry);
            mappedResponses.add(Either.right(response));
        });
        return mappedResponses;
    }
}

