/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.transfer.s3.FailedObjectTransfer;
import software.amazon.awssdk.transfer.s3.UploadFileRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@SdkPreviewApi
public final class FailedFileUpload
implements FailedObjectTransfer,
ToCopyableBuilder<Builder, FailedFileUpload> {
    private final UploadFileRequest request;
    private final Throwable exception;

    private FailedFileUpload(DefaultBuilder builder) {
        this.exception = (Throwable)Validate.paramNotNull((Object)builder.exception, (String)"exception");
        this.request = (UploadFileRequest)Validate.paramNotNull((Object)builder.request, (String)"request");
    }

    @Override
    public Throwable exception() {
        return this.exception;
    }

    @Override
    public UploadFileRequest request() {
        return this.request;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailedFileUpload that = (FailedFileUpload)o;
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        return Objects.equals(this.exception, that.exception);
    }

    public int hashCode() {
        int result = this.request != null ? this.request.hashCode() : 0;
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"FailedFileUpload").add("request", (Object)this.request).add("exception", (Object)this.exception).build();
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    private static final class DefaultBuilder
    implements Builder {
        private UploadFileRequest request;
        private Throwable exception;

        private DefaultBuilder(FailedFileUpload failedFileUpload) {
            this.request = failedFileUpload.request;
            this.exception = failedFileUpload.exception;
        }

        private DefaultBuilder() {
        }

        @Override
        public Builder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public void setException(Throwable exception) {
            this.exception(exception);
        }

        public Throwable getException() {
            return this.exception;
        }

        @Override
        public Builder request(UploadFileRequest request) {
            this.request = request;
            return this;
        }

        public void setRequest(UploadFileRequest request) {
            this.request(request);
        }

        public UploadFileRequest getRequest() {
            return this.request;
        }

        public FailedFileUpload build() {
            return new FailedFileUpload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FailedFileUpload> {
        public Builder exception(Throwable var1);

        public Builder request(UploadFileRequest var1);
    }
}

