/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.AuditPolicyState;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyActivityStreamRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyActivityStreamRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(ModifyActivityStreamRequest.getter(ModifyActivityStreamRequest::resourceArn)).setter(ModifyActivityStreamRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> AUDIT_POLICY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditPolicyState").getter(ModifyActivityStreamRequest.getter(ModifyActivityStreamRequest::auditPolicyStateAsString)).setter(ModifyActivityStreamRequest.setter(Builder::auditPolicyState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditPolicyState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, AUDIT_POLICY_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyActivityStreamRequest.memberNameToFieldInitializer();
    private final String resourceArn;
    private final String auditPolicyState;

    private ModifyActivityStreamRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.auditPolicyState = builder.auditPolicyState;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final AuditPolicyState auditPolicyState() {
        return AuditPolicyState.fromValue(this.auditPolicyState);
    }

    public final String auditPolicyStateAsString() {
        return this.auditPolicyState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditPolicyStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyActivityStreamRequest)) {
            return false;
        }
        ModifyActivityStreamRequest other = (ModifyActivityStreamRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.auditPolicyStateAsString(), other.auditPolicyStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyActivityStreamRequest").add("ResourceArn", (Object)this.resourceArn()).add("AuditPolicyState", (Object)this.auditPolicyStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "AuditPolicyState": {
                return Optional.ofNullable(clazz.cast(this.auditPolicyStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("AuditPolicyState", AUDIT_POLICY_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyActivityStreamRequest, T> g) {
        return obj -> g.apply((ModifyActivityStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private String auditPolicyState;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyActivityStreamRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.auditPolicyState(model.auditPolicyState);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getAuditPolicyState() {
            return this.auditPolicyState;
        }

        public final void setAuditPolicyState(String auditPolicyState) {
            this.auditPolicyState = auditPolicyState;
        }

        @Override
        public final Builder auditPolicyState(String auditPolicyState) {
            this.auditPolicyState = auditPolicyState;
            return this;
        }

        @Override
        public final Builder auditPolicyState(AuditPolicyState auditPolicyState) {
            this.auditPolicyState(auditPolicyState == null ? null : auditPolicyState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyActivityStreamRequest build() {
            return new ModifyActivityStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyActivityStreamRequest> {
        public Builder resourceArn(String var1);

        public Builder auditPolicyState(String var1);

        public Builder auditPolicyState(AuditPolicyState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

