/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reference details of a metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferenceDetails.Builder, ReferenceDetails> {
    private static final SdkField<ScalarReferenceDetails> SCALAR_REFERENCE_DETAILS_FIELD = SdkField
            .<ScalarReferenceDetails> builder(MarshallingType.SDK_POJO).memberName("ScalarReferenceDetails")
            .getter(getter(ReferenceDetails::scalarReferenceDetails)).setter(setter(Builder::scalarReferenceDetails))
            .constructor(ScalarReferenceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalarReferenceDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SCALAR_REFERENCE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ScalarReferenceDetails scalarReferenceDetails;

    private ReferenceDetails(BuilderImpl builder) {
        this.scalarReferenceDetails = builder.scalarReferenceDetails;
    }

    /**
     * <p>
     * The metric reference details when the reference is a scalar.
     * </p>
     * 
     * @return The metric reference details when the reference is a scalar.
     */
    public final ScalarReferenceDetails scalarReferenceDetails() {
        return scalarReferenceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scalarReferenceDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDetails)) {
            return false;
        }
        ReferenceDetails other = (ReferenceDetails) obj;
        return Objects.equals(scalarReferenceDetails(), other.scalarReferenceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceDetails").add("ScalarReferenceDetails", scalarReferenceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalarReferenceDetails":
            return Optional.ofNullable(clazz.cast(scalarReferenceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScalarReferenceDetails", SCALAR_REFERENCE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReferenceDetails, T> g) {
        return obj -> g.apply((ReferenceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceDetails> {
        /**
         * <p>
         * The metric reference details when the reference is a scalar.
         * </p>
         * 
         * @param scalarReferenceDetails
         *        The metric reference details when the reference is a scalar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalarReferenceDetails(ScalarReferenceDetails scalarReferenceDetails);

        /**
         * <p>
         * The metric reference details when the reference is a scalar.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalarReferenceDetails.Builder} avoiding
         * the need to create one manually via {@link ScalarReferenceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalarReferenceDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #scalarReferenceDetails(ScalarReferenceDetails)}.
         * 
         * @param scalarReferenceDetails
         *        a consumer that will call methods on {@link ScalarReferenceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalarReferenceDetails(ScalarReferenceDetails)
         */
        default Builder scalarReferenceDetails(Consumer<ScalarReferenceDetails.Builder> scalarReferenceDetails) {
            return scalarReferenceDetails(ScalarReferenceDetails.builder().applyMutation(scalarReferenceDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ScalarReferenceDetails scalarReferenceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDetails model) {
            scalarReferenceDetails(model.scalarReferenceDetails);
        }

        public final ScalarReferenceDetails.Builder getScalarReferenceDetails() {
            return scalarReferenceDetails != null ? scalarReferenceDetails.toBuilder() : null;
        }

        public final void setScalarReferenceDetails(ScalarReferenceDetails.BuilderImpl scalarReferenceDetails) {
            this.scalarReferenceDetails = scalarReferenceDetails != null ? scalarReferenceDetails.build() : null;
        }

        @Override
        public final Builder scalarReferenceDetails(ScalarReferenceDetails scalarReferenceDetails) {
            this.scalarReferenceDetails = scalarReferenceDetails;
            return this;
        }

        @Override
        public ReferenceDetails build() {
            return new ReferenceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
