/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The recommended status to update for the specified recommendation action ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendedActionUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendedActionUpdate.Builder, RecommendedActionUpdate> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionId").getter(getter(RecommendedActionUpdate::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RecommendedActionUpdate::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACTION_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionId;

    private final String status;

    private RecommendedActionUpdate(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.status = builder.status;
    }

    /**
     * <p>
     * A unique identifier of the updated recommendation action.
     * </p>
     * 
     * @return A unique identifier of the updated recommendation action.
     */
    public final String actionId() {
        return actionId;
    }

    /**
     * <p>
     * The status of the updated recommendation action.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>applied</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>scheduled</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the updated recommendation action.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>applied</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>scheduled</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendedActionUpdate)) {
            return false;
        }
        RecommendedActionUpdate other = (RecommendedActionUpdate) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendedActionUpdate").add("ActionId", actionId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActionId", ACTION_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendedActionUpdate, T> g) {
        return obj -> g.apply((RecommendedActionUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendedActionUpdate> {
        /**
         * <p>
         * A unique identifier of the updated recommendation action.
         * </p>
         * 
         * @param actionId
         *        A unique identifier of the updated recommendation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * The status of the updated recommendation action.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>applied</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>scheduled</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the updated recommendation action.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>applied</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>scheduled</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String actionId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendedActionUpdate model) {
            actionId(model.actionId);
            status(model.status);
        }

        public final String getActionId() {
            return actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public RecommendedActionUpdate build() {
            return new RecommendedActionUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
