/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbSnapshotAttributeResponse extends RdsResponse implements
        ToCopyableBuilder<ModifyDbSnapshotAttributeResponse.Builder, ModifyDbSnapshotAttributeResponse> {
    private static final SdkField<DBSnapshotAttributesResult> DB_SNAPSHOT_ATTRIBUTES_RESULT_FIELD = SdkField
            .<DBSnapshotAttributesResult> builder(MarshallingType.SDK_POJO)
            .memberName("DBSnapshotAttributesResult")
            .getter(getter(ModifyDbSnapshotAttributeResponse::dbSnapshotAttributesResult))
            .setter(setter(Builder::dbSnapshotAttributesResult))
            .constructor(DBSnapshotAttributesResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotAttributesResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DB_SNAPSHOT_ATTRIBUTES_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DBSnapshotAttributesResult dbSnapshotAttributesResult;

    private ModifyDbSnapshotAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.dbSnapshotAttributesResult = builder.dbSnapshotAttributesResult;
    }

    /**
     * Returns the value of the DBSnapshotAttributesResult property for this object.
     * 
     * @return The value of the DBSnapshotAttributesResult property for this object.
     */
    public final DBSnapshotAttributesResult dbSnapshotAttributesResult() {
        return dbSnapshotAttributesResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbSnapshotAttributesResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbSnapshotAttributeResponse)) {
            return false;
        }
        ModifyDbSnapshotAttributeResponse other = (ModifyDbSnapshotAttributeResponse) obj;
        return Objects.equals(dbSnapshotAttributesResult(), other.dbSnapshotAttributesResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbSnapshotAttributeResponse")
                .add("DBSnapshotAttributesResult", dbSnapshotAttributesResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSnapshotAttributesResult":
            return Optional.ofNullable(clazz.cast(dbSnapshotAttributesResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBSnapshotAttributesResult", DB_SNAPSHOT_ATTRIBUTES_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbSnapshotAttributeResponse, T> g) {
        return obj -> g.apply((ModifyDbSnapshotAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbSnapshotAttributeResponse> {
        /**
         * Sets the value of the DBSnapshotAttributesResult property for this object.
         *
         * @param dbSnapshotAttributesResult
         *        The new value for the DBSnapshotAttributesResult property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotAttributesResult(DBSnapshotAttributesResult dbSnapshotAttributesResult);

        /**
         * Sets the value of the DBSnapshotAttributesResult property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DBSnapshotAttributesResult.Builder}
         * avoiding the need to create one manually via {@link DBSnapshotAttributesResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DBSnapshotAttributesResult.Builder#build()} is called immediately
         * and its result is passed to {@link #dbSnapshotAttributesResult(DBSnapshotAttributesResult)}.
         * 
         * @param dbSnapshotAttributesResult
         *        a consumer that will call methods on {@link DBSnapshotAttributesResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSnapshotAttributesResult(DBSnapshotAttributesResult)
         */
        default Builder dbSnapshotAttributesResult(Consumer<DBSnapshotAttributesResult.Builder> dbSnapshotAttributesResult) {
            return dbSnapshotAttributesResult(DBSnapshotAttributesResult.builder().applyMutation(dbSnapshotAttributesResult)
                    .build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private DBSnapshotAttributesResult dbSnapshotAttributesResult;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbSnapshotAttributeResponse model) {
            super(model);
            dbSnapshotAttributesResult(model.dbSnapshotAttributesResult);
        }

        public final DBSnapshotAttributesResult.Builder getDbSnapshotAttributesResult() {
            return dbSnapshotAttributesResult != null ? dbSnapshotAttributesResult.toBuilder() : null;
        }

        public final void setDbSnapshotAttributesResult(DBSnapshotAttributesResult.BuilderImpl dbSnapshotAttributesResult) {
            this.dbSnapshotAttributesResult = dbSnapshotAttributesResult != null ? dbSnapshotAttributesResult.build() : null;
        }

        @Override
        public final Builder dbSnapshotAttributesResult(DBSnapshotAttributesResult dbSnapshotAttributesResult) {
            this.dbSnapshotAttributesResult = dbSnapshotAttributesResult;
            return this;
        }

        @Override
        public ModifyDbSnapshotAttributeResponse build() {
            return new ModifyDbSnapshotAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
