/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reference (threshold) for a metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricReference implements SdkPojo, Serializable, ToCopyableBuilder<MetricReference.Builder, MetricReference> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MetricReference::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ReferenceDetails> REFERENCE_DETAILS_FIELD = SdkField
            .<ReferenceDetails> builder(MarshallingType.SDK_POJO).memberName("ReferenceDetails")
            .getter(getter(MetricReference::referenceDetails)).setter(setter(Builder::referenceDetails))
            .constructor(ReferenceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            REFERENCE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ReferenceDetails referenceDetails;

    private MetricReference(BuilderImpl builder) {
        this.name = builder.name;
        this.referenceDetails = builder.referenceDetails;
    }

    /**
     * <p>
     * The name of the metric reference.
     * </p>
     * 
     * @return The name of the metric reference.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The details of a performance issue.
     * </p>
     * 
     * @return The details of a performance issue.
     */
    public final ReferenceDetails referenceDetails() {
        return referenceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(referenceDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricReference)) {
            return false;
        }
        MetricReference other = (MetricReference) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(referenceDetails(), other.referenceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricReference").add("Name", name()).add("ReferenceDetails", referenceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ReferenceDetails":
            return Optional.ofNullable(clazz.cast(referenceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ReferenceDetails", REFERENCE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricReference, T> g) {
        return obj -> g.apply((MetricReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricReference> {
        /**
         * <p>
         * The name of the metric reference.
         * </p>
         * 
         * @param name
         *        The name of the metric reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The details of a performance issue.
         * </p>
         * 
         * @param referenceDetails
         *        The details of a performance issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDetails(ReferenceDetails referenceDetails);

        /**
         * <p>
         * The details of a performance issue.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReferenceDetails.Builder} avoiding the
         * need to create one manually via {@link ReferenceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #referenceDetails(ReferenceDetails)}.
         * 
         * @param referenceDetails
         *        a consumer that will call methods on {@link ReferenceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceDetails(ReferenceDetails)
         */
        default Builder referenceDetails(Consumer<ReferenceDetails.Builder> referenceDetails) {
            return referenceDetails(ReferenceDetails.builder().applyMutation(referenceDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ReferenceDetails referenceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricReference model) {
            name(model.name);
            referenceDetails(model.referenceDetails);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ReferenceDetails.Builder getReferenceDetails() {
            return referenceDetails != null ? referenceDetails.toBuilder() : null;
        }

        public final void setReferenceDetails(ReferenceDetails.BuilderImpl referenceDetails) {
            this.referenceDetails = referenceDetails != null ? referenceDetails.build() : null;
        }

        @Override
        public final Builder referenceDetails(ReferenceDetails referenceDetails) {
            this.referenceDetails = referenceDetails;
            return this;
        }

        @Override
        public MetricReference build() {
            return new MetricReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
