/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbSnapshotsRequest extends RdsRequest implements
        ToCopyableBuilder<DescribeDbSnapshotsRequest.Builder, DescribeDbSnapshotsRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(DescribeDbSnapshotsRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSnapshotIdentifier").getter(getter(DescribeDbSnapshotsRequest::dbSnapshotIdentifier))
            .setter(setter(Builder::dbSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotType").getter(getter(DescribeDbSnapshotsRequest::snapshotType))
            .setter(setter(Builder::snapshotType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeDbSnapshotsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeDbSnapshotsRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbSnapshotsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Boolean> INCLUDE_SHARED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeShared").getter(getter(DescribeDbSnapshotsRequest::includeShared))
            .setter(setter(Builder::includeShared))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeShared").build()).build();

    private static final SdkField<Boolean> INCLUDE_PUBLIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludePublic").getter(getter(DescribeDbSnapshotsRequest::includePublic))
            .setter(setter(Builder::includePublic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePublic").build()).build();

    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbiResourceId").getter(getter(DescribeDbSnapshotsRequest::dbiResourceId))
            .setter(setter(Builder::dbiResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            DB_SNAPSHOT_IDENTIFIER_FIELD, SNAPSHOT_TYPE_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD,
            INCLUDE_SHARED_FIELD, INCLUDE_PUBLIC_FIELD, DBI_RESOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbInstanceIdentifier;

    private final String dbSnapshotIdentifier;

    private final String snapshotType;

    private final List<Filter> filters;

    private final Integer maxRecords;

    private final String marker;

    private final Boolean includeShared;

    private final Boolean includePublic;

    private final String dbiResourceId;

    private DescribeDbSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.snapshotType = builder.snapshotType;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.includeShared = builder.includeShared;
        this.includePublic = builder.includePublic;
        this.dbiResourceId = builder.dbiResourceId;
    }

    /**
     * <p>
     * The ID of the DB instance to retrieve the list of DB snapshots for. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match the identifier of an existing DBInstance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ID of the DB instance to retrieve the list of DB snapshots for. This parameter isn't
     *         case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match the identifier of an existing DBInstance.
     *         </p>
     *         </li>
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * A specific DB snapshot identifier to describe. This value is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match the identifier of an existing DBSnapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A specific DB snapshot identifier to describe. This value is stored as a lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match the identifier of an existing DBSnapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be
     *         specified.
     *         </p>
     *         </li>
     */
    public final String dbSnapshotIdentifier() {
        return dbSnapshotIdentifier;
    }

    /**
     * <p>
     * The type of snapshots to be returned. You can specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>automated</code> - Return all DB snapshots that have been automatically taken by Amazon RDS for my Amazon
     * Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>manual</code> - Return all DB snapshots that have been taken by my Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>shared</code> - Return all manual DB snapshots that have been shared to my Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>public</code> - Return all DB snapshots that have been marked as public.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>awsbackup</code> - Return the DB snapshots managed by the Amazon Web Services Backup service.
     * </p>
     * <p>
     * For information about Amazon Web Services Backup, see the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html"> <i>Amazon Web Services Backup
     * Developer Guide.</i> </a>
     * </p>
     * <p>
     * The <code>awsbackup</code> type does not apply to Aurora.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify a <code>SnapshotType</code> value, then both automated and manual snapshots are returned.
     * Shared and public DB snapshots are not included in the returned results by default. You can include shared
     * snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can include public
     * snapshots with these results by enabling the <code>IncludePublic</code> parameter.
     * </p>
     * <p>
     * The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for
     * <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code>
     * parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The
     * <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.
     * </p>
     * 
     * @return The type of snapshots to be returned. You can specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>automated</code> - Return all DB snapshots that have been automatically taken by Amazon RDS for my
     *         Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>manual</code> - Return all DB snapshots that have been taken by my Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>shared</code> - Return all manual DB snapshots that have been shared to my Amazon Web Services
     *         account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>public</code> - Return all DB snapshots that have been marked as public.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>awsbackup</code> - Return the DB snapshots managed by the Amazon Web Services Backup service.
     *         </p>
     *         <p>
     *         For information about Amazon Web Services Backup, see the <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html"> <i>Amazon Web Services
     *         Backup Developer Guide.</i> </a>
     *         </p>
     *         <p>
     *         The <code>awsbackup</code> type does not apply to Aurora.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify a <code>SnapshotType</code> value, then both automated and manual snapshots are
     *         returned. Shared and public DB snapshots are not included in the returned results by default. You can
     *         include shared snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can
     *         include public snapshots with these results by enabling the <code>IncludePublic</code> parameter.
     *         </p>
     *         <p>
     *         The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for
     *         <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The
     *         <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to
     *         <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when
     *         <code>SnapshotType</code> is set to <code>public</code>.
     */
    public final String snapshotType() {
        return snapshotType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A filter that specifies one or more DB snapshots to describe.
     * </p>
     * <p>
     * Supported filters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>snapshot-type</code> - Accepts types of DB snapshots.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>engine</code> - Accepts names of database engines.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return A filter that specifies one or more DB snapshots to describe.</p>
     *         <p>
     *         Supported filters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names
     *         (ARNs).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>snapshot-type</code> - Accepts types of DB snapshots.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>engine</code> - Accepts names of database engines.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can
     * retrieve the remaining results.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * <p>
     * Constraints: Minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you
     *         can retrieve the remaining results.</p>
     *         <p>
     *         Default: 100
     *         </p>
     *         <p>
     *         Constraints: Minimum 20, maximum 100.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribeDBSnapshots</code> request. If this parameter
     * is specified, the response includes only records beyond the marker, up to the value specified by
     * <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribeDBSnapshots</code> request. If this
     *         parameter is specified, the response includes only records beyond the marker, up to the value specified
     *         by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * Specifies whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this
     * Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not
     * included.
     * </p>
     * <p>
     * You can give an Amazon Web Services account permission to restore a manual DB snapshot from another Amazon Web
     * Services account by using the <code>ModifyDBSnapshotAttribute</code> API action.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return Specifies whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts
     *         that this Amazon Web Services account has been given permission to copy or restore. By default, these
     *         snapshots are not included.</p>
     *         <p>
     *         You can give an Amazon Web Services account permission to restore a manual DB snapshot from another
     *         Amazon Web Services account by using the <code>ModifyDBSnapshotAttribute</code> API action.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final Boolean includeShared() {
        return includeShared;
    }

    /**
     * <p>
     * Specifies whether to include manual DB cluster snapshots that are public and can be copied or restored by any
     * Amazon Web Services account. By default, the public snapshots are not included.
     * </p>
     * <p>
     * You can share a manual DB snapshot as public by using the <a>ModifyDBSnapshotAttribute</a> API.
     * </p>
     * <p>
     * This setting doesn't apply to RDS Custom.
     * </p>
     * 
     * @return Specifies whether to include manual DB cluster snapshots that are public and can be copied or restored by
     *         any Amazon Web Services account. By default, the public snapshots are not included.</p>
     *         <p>
     *         You can share a manual DB snapshot as public by using the <a>ModifyDBSnapshotAttribute</a> API.
     *         </p>
     *         <p>
     *         This setting doesn't apply to RDS Custom.
     */
    public final Boolean includePublic() {
        return includePublic;
    }

    /**
     * <p>
     * A specific DB resource ID to describe.
     * </p>
     * 
     * @return A specific DB resource ID to describe.
     */
    public final String dbiResourceId() {
        return dbiResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(includeShared());
        hashCode = 31 * hashCode + Objects.hashCode(includePublic());
        hashCode = 31 * hashCode + Objects.hashCode(dbiResourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbSnapshotsRequest)) {
            return false;
        }
        DescribeDbSnapshotsRequest other = (DescribeDbSnapshotsRequest) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(dbSnapshotIdentifier(), other.dbSnapshotIdentifier())
                && Objects.equals(snapshotType(), other.snapshotType()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker()) && Objects.equals(includeShared(), other.includeShared())
                && Objects.equals(includePublic(), other.includePublic())
                && Objects.equals(dbiResourceId(), other.dbiResourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbSnapshotsRequest").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("DBSnapshotIdentifier", dbSnapshotIdentifier()).add("SnapshotType", snapshotType())
                .add("Filters", hasFilters() ? filters() : null).add("MaxRecords", maxRecords()).add("Marker", marker())
                .add("IncludeShared", includeShared()).add("IncludePublic", includePublic())
                .add("DbiResourceId", dbiResourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "DBSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(dbSnapshotIdentifier()));
        case "SnapshotType":
            return Optional.ofNullable(clazz.cast(snapshotType()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "IncludeShared":
            return Optional.ofNullable(clazz.cast(includeShared()));
        case "IncludePublic":
            return Optional.ofNullable(clazz.cast(includePublic()));
        case "DbiResourceId":
            return Optional.ofNullable(clazz.cast(dbiResourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("DBSnapshotIdentifier", DB_SNAPSHOT_IDENTIFIER_FIELD);
        map.put("SnapshotType", SNAPSHOT_TYPE_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("IncludeShared", INCLUDE_SHARED_FIELD);
        map.put("IncludePublic", INCLUDE_PUBLIC_FIELD);
        map.put("DbiResourceId", DBI_RESOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeDbSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbSnapshotsRequest> {
        /**
         * <p>
         * The ID of the DB instance to retrieve the list of DB snapshots for. This parameter isn't case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match the identifier of an existing DBInstance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbInstanceIdentifier
         *        The ID of the DB instance to retrieve the list of DB snapshots for. This parameter isn't
         *        case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match the identifier of an existing DBInstance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * A specific DB snapshot identifier to describe. This value is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match the identifier of an existing DBSnapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be
         * specified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbSnapshotIdentifier
         *        A specific DB snapshot identifier to describe. This value is stored as a lowercase string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match the identifier of an existing DBSnapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be
         *        specified.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotIdentifier(String dbSnapshotIdentifier);

        /**
         * <p>
         * The type of snapshots to be returned. You can specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>automated</code> - Return all DB snapshots that have been automatically taken by Amazon RDS for my
         * Amazon Web Services account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>manual</code> - Return all DB snapshots that have been taken by my Amazon Web Services account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>shared</code> - Return all manual DB snapshots that have been shared to my Amazon Web Services account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>public</code> - Return all DB snapshots that have been marked as public.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>awsbackup</code> - Return the DB snapshots managed by the Amazon Web Services Backup service.
         * </p>
         * <p>
         * For information about Amazon Web Services Backup, see the <a
         * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html"> <i>Amazon Web Services
         * Backup Developer Guide.</i> </a>
         * </p>
         * <p>
         * The <code>awsbackup</code> type does not apply to Aurora.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify a <code>SnapshotType</code> value, then both automated and manual snapshots are
         * returned. Shared and public DB snapshots are not included in the returned results by default. You can include
         * shared snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can include
         * public snapshots with these results by enabling the <code>IncludePublic</code> parameter.
         * </p>
         * <p>
         * The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for
         * <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The
         * <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to
         * <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is
         * set to <code>public</code>.
         * </p>
         * 
         * @param snapshotType
         *        The type of snapshots to be returned. You can specify one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>automated</code> - Return all DB snapshots that have been automatically taken by Amazon RDS for
         *        my Amazon Web Services account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>manual</code> - Return all DB snapshots that have been taken by my Amazon Web Services account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>shared</code> - Return all manual DB snapshots that have been shared to my Amazon Web Services
         *        account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>public</code> - Return all DB snapshots that have been marked as public.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>awsbackup</code> - Return the DB snapshots managed by the Amazon Web Services Backup service.
         *        </p>
         *        <p>
         *        For information about Amazon Web Services Backup, see the <a
         *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html"> <i>Amazon Web
         *        Services Backup Developer Guide.</i> </a>
         *        </p>
         *        <p>
         *        The <code>awsbackup</code> type does not apply to Aurora.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify a <code>SnapshotType</code> value, then both automated and manual snapshots are
         *        returned. Shared and public DB snapshots are not included in the returned results by default. You can
         *        include shared snapshots with these results by enabling the <code>IncludeShared</code> parameter. You
         *        can include public snapshots with these results by enabling the <code>IncludePublic</code> parameter.
         *        </p>
         *        <p>
         *        The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for
         *        <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The
         *        <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to
         *        <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when
         *        <code>SnapshotType</code> is set to <code>public</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotType(String snapshotType);

        /**
         * <p>
         * A filter that specifies one or more DB snapshots to describe.
         * </p>
         * <p>
         * Supported filters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-type</code> - Accepts types of DB snapshots.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>engine</code> - Accepts names of database engines.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        A filter that specifies one or more DB snapshots to describe.</p>
         *        <p>
         *        Supported filters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names
         *        (ARNs).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>snapshot-type</code> - Accepts types of DB snapshots.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>engine</code> - Accepts names of database engines.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * A filter that specifies one or more DB snapshots to describe.
         * </p>
         * <p>
         * Supported filters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-type</code> - Accepts types of DB snapshots.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>engine</code> - Accepts names of database engines.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        A filter that specifies one or more DB snapshots to describe.</p>
         *        <p>
         *        Supported filters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names
         *        (ARNs).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>snapshot-type</code> - Accepts types of DB snapshots.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>engine</code> - Accepts names of database engines.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * A filter that specifies one or more DB snapshots to describe.
         * </p>
         * <p>
         * Supported filters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-type</code> - Accepts types of DB snapshots.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>engine</code> - Accepts names of database engines.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can
         * retrieve the remaining results.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * <p>
         * Constraints: Minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that
         *        you can retrieve the remaining results.</p>
         *        <p>
         *        Default: 100
         *        </p>
         *        <p>
         *        Constraints: Minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribeDBSnapshots</code> request. If this
         * parameter is specified, the response includes only records beyond the marker, up to the value specified by
         * <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribeDBSnapshots</code> request. If this
         *        parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Specifies whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that
         * this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots
         * are not included.
         * </p>
         * <p>
         * You can give an Amazon Web Services account permission to restore a manual DB snapshot from another Amazon
         * Web Services account by using the <code>ModifyDBSnapshotAttribute</code> API action.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param includeShared
         *        Specifies whether to include shared manual DB cluster snapshots from other Amazon Web Services
         *        accounts that this Amazon Web Services account has been given permission to copy or restore. By
         *        default, these snapshots are not included.</p>
         *        <p>
         *        You can give an Amazon Web Services account permission to restore a manual DB snapshot from another
         *        Amazon Web Services account by using the <code>ModifyDBSnapshotAttribute</code> API action.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeShared(Boolean includeShared);

        /**
         * <p>
         * Specifies whether to include manual DB cluster snapshots that are public and can be copied or restored by any
         * Amazon Web Services account. By default, the public snapshots are not included.
         * </p>
         * <p>
         * You can share a manual DB snapshot as public by using the <a>ModifyDBSnapshotAttribute</a> API.
         * </p>
         * <p>
         * This setting doesn't apply to RDS Custom.
         * </p>
         * 
         * @param includePublic
         *        Specifies whether to include manual DB cluster snapshots that are public and can be copied or restored
         *        by any Amazon Web Services account. By default, the public snapshots are not included.</p>
         *        <p>
         *        You can share a manual DB snapshot as public by using the <a>ModifyDBSnapshotAttribute</a> API.
         *        </p>
         *        <p>
         *        This setting doesn't apply to RDS Custom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includePublic(Boolean includePublic);

        /**
         * <p>
         * A specific DB resource ID to describe.
         * </p>
         * 
         * @param dbiResourceId
         *        A specific DB resource ID to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbiResourceId(String dbiResourceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private String dbSnapshotIdentifier;

        private String snapshotType;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String marker;

        private Boolean includeShared;

        private Boolean includePublic;

        private String dbiResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbSnapshotsRequest model) {
            super(model);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            snapshotType(model.snapshotType);
            filters(model.filters);
            maxRecords(model.maxRecords);
            marker(model.marker);
            includeShared(model.includeShared);
            includePublic(model.includePublic);
            dbiResourceId(model.dbiResourceId);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getDbSnapshotIdentifier() {
            return dbSnapshotIdentifier;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final String getSnapshotType() {
            return snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getIncludeShared() {
            return includeShared;
        }

        public final void setIncludeShared(Boolean includeShared) {
            this.includeShared = includeShared;
        }

        @Override
        public final Builder includeShared(Boolean includeShared) {
            this.includeShared = includeShared;
            return this;
        }

        public final Boolean getIncludePublic() {
            return includePublic;
        }

        public final void setIncludePublic(Boolean includePublic) {
            this.includePublic = includePublic;
        }

        @Override
        public final Builder includePublic(Boolean includePublic) {
            this.includePublic = includePublic;
            return this;
        }

        public final String getDbiResourceId() {
            return dbiResourceId;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDbSnapshotsRequest build() {
            return new DescribeDbSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
