/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element to <code>DescribeDBLogFiles</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDBLogFilesDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeDBLogFilesDetails.Builder, DescribeDBLogFilesDetails> {
    private static final SdkField<String> LOG_FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFileName").getter(getter(DescribeDBLogFilesDetails::logFileName))
            .setter(setter(Builder::logFileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFileName").build()).build();

    private static final SdkField<Long> LAST_WRITTEN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastWritten").getter(getter(DescribeDBLogFilesDetails::lastWritten))
            .setter(setter(Builder::lastWritten))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastWritten").build()).build();

    private static final SdkField<Long> SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Size")
            .getter(getter(DescribeDBLogFilesDetails::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_FILE_NAME_FIELD,
            LAST_WRITTEN_FIELD, SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logFileName;

    private final Long lastWritten;

    private final Long size;

    private DescribeDBLogFilesDetails(BuilderImpl builder) {
        this.logFileName = builder.logFileName;
        this.lastWritten = builder.lastWritten;
        this.size = builder.size;
    }

    /**
     * <p>
     * The name of the log file for the specified DB instance.
     * </p>
     * 
     * @return The name of the log file for the specified DB instance.
     */
    public final String logFileName() {
        return logFileName;
    }

    /**
     * <p>
     * A POSIX timestamp when the last log entry was written.
     * </p>
     * 
     * @return A POSIX timestamp when the last log entry was written.
     */
    public final Long lastWritten() {
        return lastWritten;
    }

    /**
     * <p>
     * The size, in bytes, of the log file for the specified DB instance.
     * </p>
     * 
     * @return The size, in bytes, of the log file for the specified DB instance.
     */
    public final Long size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logFileName());
        hashCode = 31 * hashCode + Objects.hashCode(lastWritten());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBLogFilesDetails)) {
            return false;
        }
        DescribeDBLogFilesDetails other = (DescribeDBLogFilesDetails) obj;
        return Objects.equals(logFileName(), other.logFileName()) && Objects.equals(lastWritten(), other.lastWritten())
                && Objects.equals(size(), other.size());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDBLogFilesDetails").add("LogFileName", logFileName()).add("LastWritten", lastWritten())
                .add("Size", size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogFileName":
            return Optional.ofNullable(clazz.cast(logFileName()));
        case "LastWritten":
            return Optional.ofNullable(clazz.cast(lastWritten()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogFileName", LOG_FILE_NAME_FIELD);
        map.put("LastWritten", LAST_WRITTEN_FIELD);
        map.put("Size", SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDBLogFilesDetails, T> g) {
        return obj -> g.apply((DescribeDBLogFilesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeDBLogFilesDetails> {
        /**
         * <p>
         * The name of the log file for the specified DB instance.
         * </p>
         * 
         * @param logFileName
         *        The name of the log file for the specified DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFileName(String logFileName);

        /**
         * <p>
         * A POSIX timestamp when the last log entry was written.
         * </p>
         * 
         * @param lastWritten
         *        A POSIX timestamp when the last log entry was written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastWritten(Long lastWritten);

        /**
         * <p>
         * The size, in bytes, of the log file for the specified DB instance.
         * </p>
         * 
         * @param size
         *        The size, in bytes, of the log file for the specified DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);
    }

    static final class BuilderImpl implements Builder {
        private String logFileName;

        private Long lastWritten;

        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBLogFilesDetails model) {
            logFileName(model.logFileName);
            lastWritten(model.lastWritten);
            size(model.size);
        }

        public final String getLogFileName() {
            return logFileName;
        }

        public final void setLogFileName(String logFileName) {
            this.logFileName = logFileName;
        }

        @Override
        public final Builder logFileName(String logFileName) {
            this.logFileName = logFileName;
            return this;
        }

        public final Long getLastWritten() {
            return lastWritten;
        }

        public final void setLastWritten(Long lastWritten) {
            this.lastWritten = lastWritten;
        }

        @Override
        public final Builder lastWritten(Long lastWritten) {
            this.lastWritten = lastWritten;
            return this;
        }

        public final Long getSize() {
            return size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        @Override
        public DescribeDBLogFilesDetails build() {
            return new DescribeDBLogFilesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
