/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.mockito.Mockito;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.http.DelegatingServletOutputStream;
import ro.isdc.wro.manager.factory.standalone.DefaultStandaloneContextAwareManagerFactory;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;
import ro.isdc.wro.manager.factory.standalone.StandaloneContextAwareManagerFactory;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.util.encoding.SmartEncodingInputStream;
import ro.isdc.wro.util.io.UnclosableBufferedInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wro4jMojo
extends AbstractMojo {
    private File wroFile;
    private File contextFolder;
    private File destinationFolder;
    private File cssDestinationFolder;
    private File jsDestinationFolder;
    private String targetGroups;
    private boolean minimize;
    private boolean ignoreMissingResources;
    private String wroManagerFactory;
    private MavenProject mavenProject;
    private StandaloneContextAwareManagerFactory managerFactory;

    private StandaloneContextAwareManagerFactory getManagerFactory() throws MojoExecutionException {
        if (this.managerFactory == null) {
            this.managerFactory = this.wroManagerFactory != null ? this.createCustomManagerFactory() : this.createDefaultManagerFactory();
            this.managerFactory.initialize(this.createStandaloneContext());
        }
        return this.managerFactory;
    }

    private StandaloneContextAwareManagerFactory createCustomManagerFactory() throws MojoExecutionException {
        StandaloneContextAwareManagerFactory managerFactory;
        try {
            Class<?> wroManagerFactoryClass = Thread.currentThread().getContextClassLoader().loadClass(this.wroManagerFactory.trim());
            managerFactory = (StandaloneContextAwareManagerFactory)wroManagerFactoryClass.newInstance();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Invalid wroManagerFactory class named: " + this.wroManagerFactory);
        }
        return managerFactory;
    }

    private StandaloneContextAwareManagerFactory createDefaultManagerFactory() {
        return new DefaultStandaloneContextAwareManagerFactory();
    }

    private StandaloneContext createStandaloneContext() {
        StandaloneContext runContext = new StandaloneContext();
        runContext.setContextFolder(this.contextFolder);
        runContext.setMinimize(this.minimize);
        runContext.setWroFile(this.wroFile);
        runContext.setIgnoreMissingResources(this.ignoreMissingResources);
        return runContext;
    }

    public void execute() throws MojoExecutionException {
        this.validate();
        this.extendPluginClasspath();
        this.getLog().info((CharSequence)"Executing the mojo: ");
        this.getLog().info((CharSequence)("Wro4j Model path: " + this.wroFile.getPath()));
        this.getLog().info((CharSequence)("targetGroups: " + this.targetGroups));
        this.getLog().info((CharSequence)("minimize: " + this.minimize));
        this.getLog().info((CharSequence)("destinationFolder: " + this.destinationFolder));
        this.getLog().info((CharSequence)("jsDestinationFolder: " + this.jsDestinationFolder));
        this.getLog().info((CharSequence)("cssDestinationFolder: " + this.cssDestinationFolder));
        this.getLog().info((CharSequence)("ignoreMissingResources: " + this.ignoreMissingResources));
        Context.set((Context)Context.standaloneContext());
        try {
            List<String> groupsAsList = this.getTargetGroupsAsList();
            for (String group : groupsAsList) {
                for (ResourceType resourceType : ResourceType.values()) {
                    File destinationFolder = this.computeDestinationFolder(resourceType);
                    String groupWithExtension = group + "." + resourceType.name().toLowerCase();
                    this.processGroup(groupWithExtension, destinationFolder);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception occured while processing: " + e.getMessage(), e);
        }
    }

    private String rename(String group, InputStream input) throws MojoExecutionException {
        try {
            return this.getManagerFactory().getNamingStrategy().rename(group, input);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error occured during renaming", (Exception)e);
        }
    }

    private File computeDestinationFolder(ResourceType resourceType) throws MojoExecutionException {
        File folder = this.destinationFolder;
        if (resourceType == ResourceType.JS && this.jsDestinationFolder != null) {
            folder = this.jsDestinationFolder;
        }
        if (resourceType == ResourceType.CSS && this.cssDestinationFolder != null) {
            folder = this.cssDestinationFolder;
        }
        this.getLog().info((CharSequence)("folder: " + folder));
        if (folder == null) {
            throw new MojoExecutionException("Couldn't compute destination folder for resourceType: " + resourceType + ". That means that you didn't define one of the following parameters: " + "destinationFolder, cssDestinationFolder, jsDestinationFolder");
        }
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    private void validate() throws MojoExecutionException {
        if (this.wroFile == null) {
            throw new MojoExecutionException("wroFile was not set!");
        }
        if (this.destinationFolder == null) {
            throw new MojoExecutionException("destinationFolder was not set!");
        }
        if (this.contextFolder == null) {
            throw new MojoExecutionException("contextFolder was not set!");
        }
    }

    private void extendPluginClasspath() throws MojoExecutionException {
        List classpathElements = null;
        try {
            classpathElements = this.mavenProject.getRuntimeClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not get compile classpath elements", (Exception)((Object)e));
        }
        ClassRealm realm = this.createRealm(classpathElements);
        Thread.currentThread().setContextClassLoader(realm.getClassLoader());
    }

    private ClassRealm createRealm(List<String> classpathElements) {
        ClassRealm realm;
        ClassWorld world = new ClassWorld();
        this.getLog().debug((CharSequence)"Classpath elements:");
        try {
            realm = world.newRealm("maven.plugin." + ((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getContextClassLoader());
            for (String element : classpathElements) {
                File elementFile = new File(element);
                this.getLog().debug((CharSequence)("Adding element to plugin classpath: " + elementFile.getPath()));
                URL url = new URL("file:///" + elementFile.getPath() + (elementFile.isDirectory() ? "/" : ""));
                realm.addConstituent(url);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error retreiving URL for artifact", (Throwable)e);
            throw new RuntimeException(e);
        }
        return realm;
    }

    private List<String> getTargetGroupsAsList() throws MojoExecutionException {
        if (this.targetGroups == null) {
            WroModel model = this.getManagerFactory().getInstance().getModel();
            return model.getGroupNames();
        }
        return Arrays.asList(this.targetGroups.split(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGroup(String group, File parentFoder) throws IOException, MojoExecutionException {
        ByteArrayOutputStream resultOutputStream = null;
        InputStream resultInputStream = null;
        try {
            this.getLog().info((CharSequence)("processing group: " + group));
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURI()).thenReturn((Object)group);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            resultOutputStream = new ByteArrayOutputStream();
            Mockito.when((Object)response.getOutputStream()).thenReturn((Object)new DelegatingServletOutputStream((OutputStream)resultOutputStream));
            Context.set((Context)Context.webContext((HttpServletRequest)request, (HttpServletResponse)response, (FilterConfig)((FilterConfig)Mockito.mock(FilterConfig.class))));
            this.getManagerFactory().getInstance().process();
            resultInputStream = new UnclosableBufferedInputStream(resultOutputStream.toByteArray());
            File destinationFile = new File(parentFoder, this.rename(group, resultInputStream));
            destinationFile.createNewFile();
            resultInputStream.reset();
            this.getLog().debug((CharSequence)("Created file: " + destinationFile.getName()));
            FileOutputStream fos = new FileOutputStream(destinationFile);
            IOUtils.copy((InputStream)new SmartEncodingInputStream(resultInputStream), (OutputStream)fos);
            ((OutputStream)fos).close();
            this.getLog().info((CharSequence)("file size: " + destinationFile.getName() + " -> " + destinationFile.length() + " bytes"));
            if (destinationFile.length() == 0L) {
                this.getLog().info((CharSequence)("No content found for group: " + group));
                destinationFile.delete();
            } else {
                this.getLog().info((CharSequence)(destinationFile.getAbsolutePath() + " (" + destinationFile.length() + "bytes" + ") has been created!"));
            }
        }
        finally {
            if (resultOutputStream != null) {
                resultOutputStream.close();
            }
            if (resultInputStream != null) {
                resultInputStream.close();
            }
        }
    }

    public void setWroFile(File wroFile) {
        this.wroFile = wroFile;
    }

    public void setDestinationFolder(File destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public void setCssDestinationFolder(File cssDestinationFolder) {
        this.cssDestinationFolder = cssDestinationFolder;
    }

    public void setJsDestinationFolder(File jsDestinationFolder) {
        this.jsDestinationFolder = jsDestinationFolder;
    }

    public void setContextFolder(File contextFolder) {
        this.contextFolder = contextFolder;
    }

    public void setTargetGroups(String targetGroups) {
        this.targetGroups = targetGroups;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public void setIgnoreMissingResources(boolean ignoreMissingResources) {
        this.ignoreMissingResources = ignoreMissingResources;
    }

    public void setWroManagerFactory(String wroManagerFactory) {
        this.wroManagerFactory = wroManagerFactory;
    }

    void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }
}

