/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import wiremock.jakarta.servlet.Filter;
import wiremock.jakarta.servlet.FilterChain;
import wiremock.jakarta.servlet.FilterConfig;
import wiremock.jakarta.servlet.ServletException;
import wiremock.jakarta.servlet.ServletRequest;
import wiremock.jakarta.servlet.ServletRequestEvent;
import wiremock.jakarta.servlet.ServletRequestListener;
import wiremock.jakarta.servlet.ServletResponse;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.jakarta.servlet.http.HttpSession;
import wiremock.jakarta.servlet.http.PushBuilder;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.HttpURI;
import wiremock.org.eclipse.jetty.util.NanoTime;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class PushSessionCacheFilter
implements Filter {
    private static final String RESPONSE_ATTR = "PushSessionCacheFilter.response";
    private static final String TARGET_ATTR = "PushSessionCacheFilter.target";
    private static final String TIMESTAMP_ATTR = "PushSessionCacheFilter.timestamp";
    private static final Logger LOG = LoggerFactory.getLogger(PushSessionCacheFilter.class);
    private final ConcurrentMap<String, Target> _cache = new ConcurrentHashMap<String, Target>();
    private long _associateDelay = 5000L;

    @Override
    public void init(FilterConfig config) throws ServletException {
        if (config.getInitParameter("associateDelay") != null) {
            this._associateDelay = Long.parseLong(config.getInitParameter("associateDelay"));
        }
        config.getServletContext().addListener(new ServletRequestListener(){

            @Override
            public void requestDestroyed(ServletRequestEvent sre) {
                String referer;
                HttpServletRequest request = (HttpServletRequest)sre.getServletRequest();
                Target target = (Target)request.getAttribute(PushSessionCacheFilter.TARGET_ATTR);
                if (target == null) {
                    return;
                }
                HttpServletResponse response = (HttpServletResponse)request.getAttribute(PushSessionCacheFilter.RESPONSE_ATTR);
                target._etag = response.getHeader(HttpHeader.ETAG.asString());
                target._lastModified = response.getHeader(HttpHeader.LAST_MODIFIED.asString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Served {} for {}", (Object)response.getStatus(), (Object)request.getRequestURI());
                }
                if ((referer = request.getHeader(HttpHeader.REFERER.asString())) != null) {
                    HttpSession session;
                    ConcurrentHashMap timestamps;
                    Long last;
                    Target refererTarget;
                    HttpURI.Immutable refererUri = HttpURI.from(referer);
                    if (request.getServerName().equals(refererUri.getHost()) && (refererTarget = (Target)PushSessionCacheFilter.this._cache.get(refererUri.getPath())) != null && (last = (Long)(timestamps = (ConcurrentHashMap)(session = request.getSession()).getAttribute(PushSessionCacheFilter.TIMESTAMP_ATTR)).get(refererTarget._path)) != null && NanoTime.millisSince(last) < PushSessionCacheFilter.this._associateDelay && refererTarget._associated.putIfAbsent(target._path, target) == null && LOG.isDebugEnabled()) {
                        LOG.debug("ASSOCIATE {}->{}", (Object)refererTarget._path, (Object)target._path);
                    }
                }
            }

            @Override
            public void requestInitialized(ServletRequestEvent sre) {
            }
        });
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        req.setAttribute(RESPONSE_ATTR, resp);
        HttpServletRequest request = (HttpServletRequest)req;
        String uri = request.getRequestURI();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {}", (Object)request.getMethod(), (Object)uri);
        }
        HttpSession session = request.getSession(true);
        Target target = (Target)this._cache.get(uri);
        if (target == null) {
            Target t2 = new Target(uri);
            target = this._cache.putIfAbsent(uri, t2);
            target = target == null ? t2 : target;
        }
        request.setAttribute(TARGET_ATTR, target);
        ConcurrentHashMap<String, Long> timestamps = (ConcurrentHashMap<String, Long>)session.getAttribute(TIMESTAMP_ATTR);
        if (timestamps == null) {
            timestamps = new ConcurrentHashMap<String, Long>();
            session.setAttribute(TIMESTAMP_ATTR, timestamps);
        }
        timestamps.put(uri, NanoTime.now());
        PushBuilder builder = request.newPushBuilder();
        if (builder != null && !target._associated.isEmpty()) {
            boolean conditional = request.getHeader(HttpHeader.IF_NONE_MATCH.asString()) != null || request.getHeader(HttpHeader.IF_MODIFIED_SINCE.asString()) != null;
            ArrayDeque<Target> queue = new ArrayDeque<Target>();
            queue.offer(target);
            while (!queue.isEmpty()) {
                Target parent = (Target)queue.poll();
                builder.addHeader("X-Pusher", PushSessionCacheFilter.class.toString());
                for (Target child : parent._associated.values()) {
                    queue.offer(child);
                    String path = child._path;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("PUSH {} <- {}", (Object)path, (Object)uri);
                    }
                    builder.path(path).setHeader(HttpHeader.IF_NONE_MATCH.asString(), conditional ? child._etag : null).setHeader(HttpHeader.IF_MODIFIED_SINCE.asString(), conditional ? child._lastModified : null);
                }
            }
        }
        chain.doFilter(req, resp);
    }

    @Override
    public void destroy() {
        this._cache.clear();
    }

    private static class Target {
        private final String _path;
        private final ConcurrentMap<String, Target> _associated = new ConcurrentHashMap<String, Target>();
        private volatile String _etag;
        private volatile String _lastModified;

        private Target(String path) {
            this._path = path;
        }

        public String toString() {
            return String.format("Target{p=%s,e=%s,m=%s,a=%d}", this._path, this._etag, this._lastModified, this._associated.size());
        }
    }
}

