/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonType;
import wiremock.com.networknt.schema.ThresholdMixin;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.utils.JsonNodeUtil;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class MaximumValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MaximumValidator.class);
    private static final String PROPERTY_EXCLUSIVE_MAXIMUM = "exclusiveMaximum";
    private boolean excludeEqual = false;
    private final ThresholdMixin typedMaximum;

    public MaximumValidator(String schemaPath, final JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MAXIMUM, validationContext);
        this.validationContext = validationContext;
        if (!schemaNode.isNumber()) {
            throw new JsonSchemaException("maximum value is not a number");
        }
        JsonNode exclusiveMaximumNode = this.getParentSchema().getSchemaNode().get(PROPERTY_EXCLUSIVE_MAXIMUM);
        if (exclusiveMaximumNode != null && exclusiveMaximumNode.isBoolean()) {
            this.excludeEqual = exclusiveMaximumNode.booleanValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
        final String maximumText = schemaNode.asText();
        if ((schemaNode.isLong() || schemaNode.isInt()) && JsonType.INTEGER.toString().equals(this.getNodeFieldType())) {
            final long lm = schemaNode.asLong();
            this.typedMaximum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    if (node.isBigInteger()) {
                        int compare = node.bigIntegerValue().compareTo(new BigInteger(schemaNode.asText()));
                        return compare > 0 || MaximumValidator.this.excludeEqual && compare == 0;
                    }
                    if (node.isTextual()) {
                        BigDecimal max = new BigDecimal(maximumText);
                        BigDecimal value = new BigDecimal(node.asText());
                        int compare = value.compareTo(max);
                        return compare > 0 || MaximumValidator.this.excludeEqual && compare == 0;
                    }
                    long val = node.asLong();
                    return lm < val || MaximumValidator.this.excludeEqual && lm == val;
                }

                @Override
                public String thresholdValue() {
                    return String.valueOf(lm);
                }
            };
        } else {
            this.typedMaximum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    if (schemaNode.isDouble() && schemaNode.doubleValue() == Double.POSITIVE_INFINITY) {
                        return false;
                    }
                    if (schemaNode.isDouble() && schemaNode.doubleValue() == Double.NEGATIVE_INFINITY) {
                        return true;
                    }
                    if (node.isDouble() && node.doubleValue() == Double.NEGATIVE_INFINITY) {
                        return false;
                    }
                    if (node.isDouble() && node.doubleValue() == Double.POSITIVE_INFINITY) {
                        return true;
                    }
                    BigDecimal max = new BigDecimal(maximumText);
                    BigDecimal value = new BigDecimal(node.asText());
                    int compare = value.compareTo(max);
                    return compare > 0 || MaximumValidator.this.excludeEqual && compare == 0;
                }

                @Override
                public String thresholdValue() {
                    return maximumText;
                }
            };
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        MaximumValidator.debug(logger, node, rootNode, at);
        if (!JsonNodeUtil.isNumber(node, this.validationContext.getConfig())) {
            return Collections.emptySet();
        }
        if (this.typedMaximum.crossesThreshold(node)) {
            return Collections.singleton(this.buildValidationMessage(at, this.typedMaximum.thresholdValue()));
        }
        return Collections.emptySet();
    }
}

