/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.NamedValueMatcher;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractLogicalMatcher
extends StringValuePattern {
    protected final List<StringValuePattern> operands;

    public AbstractLogicalMatcher(StringValuePattern ... operands) {
        this(Arrays.asList(operands));
    }

    public AbstractLogicalMatcher(List<StringValuePattern> operands) {
        super(AbstractLogicalMatcher.checkAtLeast2OperandsAndReturnFirstExpected(operands));
        this.operands = operands;
    }

    private static String checkAtLeast2OperandsAndReturnFirstExpected(List<StringValuePattern> operands) {
        if (operands.size() < 2) {
            throw new IllegalArgumentException("Must be constructed with at least two matchers");
        }
        return operands.stream().findFirst().map(NamedValueMatcher::getExpected).orElseThrow(() -> new IllegalArgumentException("Matchers must have expected values"));
    }

    @Override
    public String getExpected() {
        return this.operands.stream().map(contentPattern -> contentPattern.getName() + " " + contentPattern.getExpected()).collect(Collectors.joining(" " + this.getOperationName() + " "));
    }

    protected abstract String getOperationName();
}

