/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor.attr;

import java.util.Arrays;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;
import org.thymeleaf.spring4.util.FieldUtils;
import org.thymeleaf.standard.processor.attr.AbstractStandardSingleAttributeModifierAttrProcessor;
import org.thymeleaf.util.StringUtils;

public final class SpringErrorClassAttrProcessor
extends AbstractStandardSingleAttributeModifierAttrProcessor {
    public static final int ATTR_PRECEDENCE = 1500;
    public static final String ATTR_NAME = "errorclass";
    public static final String TARGET_ATTR_NAME = "class";

    public SpringErrorClassAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 1500;
    }

    protected String getTargetAttributeName(Arguments arguments, Element element, String attributeName) {
        return TARGET_ATTR_NAME;
    }

    protected String getTargetAttributeValue(Arguments arguments, Element element, String attributeName) {
        String fieldName = element.getAttributeValueFromNormalizedName("name");
        if (StringUtils.isEmptyOrWhitespace((String)fieldName)) {
            String[] fieldProcessorNames = Attribute.applyPrefixToAttributeName((String)"field", (String)Attribute.getPrefixFromAttributeName((String)attributeName));
            throw new TemplateProcessingException("Cannot apply \"" + attributeName + "\": this attribute requires the existence of " + "a \"name\" (or " + Arrays.asList(fieldProcessorNames) + ") attribute with non-empty " + "value in the same host tag.");
        }
        if (FieldUtils.hasErrors(arguments.getConfiguration(), (IProcessingContext)arguments, fieldName)) {
            return super.getTargetAttributeValue(arguments, element, attributeName);
        }
        return "";
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.APPEND_WITH_SPACE;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return true;
    }
}

