/*
 * Decompiled with CFR 0.152.
 */
package tachyon.network.protocol;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import tachyon.network.protocol.RPCMessage;
import tachyon.network.protocol.RPCRequest;
import tachyon.network.protocol.databuffer.DataBuffer;
import tachyon.network.protocol.databuffer.DataByteBuffer;

public final class RPCBlockWriteRequest
extends RPCRequest {
    private final long mSessionId;
    private final long mBlockId;
    private final long mOffset;
    private final long mLength;
    private final DataBuffer mData;

    public RPCBlockWriteRequest(long sessionId, long blockId, long offset, long length, DataBuffer data) {
        this.mSessionId = sessionId;
        this.mBlockId = blockId;
        this.mOffset = offset;
        this.mLength = length;
        this.mData = data;
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_BLOCK_WRITE_REQUEST;
    }

    public static RPCBlockWriteRequest decode(ByteBuf in) {
        long sessionId = in.readLong();
        long blockId = in.readLong();
        long offset = in.readLong();
        long length = in.readLong();
        ByteBuffer buffer = ByteBuffer.allocate((int)length);
        in.readBytes(buffer);
        DataByteBuffer data = new DataByteBuffer(buffer, (int)length);
        return new RPCBlockWriteRequest(sessionId, blockId, offset, length, data);
    }

    @Override
    public int getEncodedLength() {
        return 32;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.mSessionId);
        out.writeLong(this.mBlockId);
        out.writeLong(this.mOffset);
        out.writeLong(this.mLength);
    }

    @Override
    public DataBuffer getPayloadDataBuffer() {
        return this.mData;
    }

    public long getSessionId() {
        return this.mSessionId;
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }
}

