/*
 * Decompiled with CFR 0.152.
 */
package tachyon.hadoop;

import com.google.common.primitives.Ints;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.ReadType;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.file.FileInStream;
import tachyon.conf.TachyonConf;
import tachyon.util.io.BufferUtils;

public class HdfsFileInputStream
extends InputStream
implements Seekable,
PositionedReadable {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private long mCurrentPosition;
    private TachyonFS mTFS;
    private long mFileId;
    private Path mHdfsPath;
    private Configuration mHadoopConf;
    private int mHadoopBufferSize;
    private FileSystem.Statistics mStatistics;
    private TachyonFile mTachyonFile;
    private FSDataInputStream mHdfsInputStream = null;
    private FileInStream mTachyonFileInputStream = null;
    private boolean mClosed = false;
    private int mBufferLimit = 0;
    private int mBufferPosition = 0;
    private byte[] mBuffer;
    private final TachyonConf mTachyonConf;

    public HdfsFileInputStream(TachyonFS tfs, long fileId, Path hdfsPath, Configuration conf, int bufferSize, FileSystem.Statistics stats, TachyonConf tachyonConf) throws IOException {
        LOG.debug("HdfsFileInputStream({}, {}, {}, {}, {}, {})", new Object[]{tfs, fileId, hdfsPath, conf, bufferSize, stats});
        this.mTachyonConf = tachyonConf;
        long bufferBytes = this.mTachyonConf.getBytes("tachyon.user.file.buffer.bytes");
        this.mBuffer = new byte[Ints.checkedCast((long)bufferBytes) * 4];
        this.mCurrentPosition = 0L;
        this.mTFS = tfs;
        this.mFileId = fileId;
        this.mHdfsPath = hdfsPath;
        this.mHadoopConf = conf;
        this.mHadoopBufferSize = bufferSize;
        this.mStatistics = stats;
        this.mTachyonFile = this.mTFS.getFile(this.mFileId);
        if (this.mTachyonFile == null) {
            throw new FileNotFoundException("File " + hdfsPath + " with FID " + fileId + " is not found.");
        }
        this.mTachyonFile.setUFSConf(this.mHadoopConf);
        this.mTachyonFileInputStream = this.mTachyonFile.getInStream(ReadType.CACHE);
    }

    @Override
    public int available() throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public void close() throws IOException {
        if (this.mTachyonFileInputStream != null) {
            this.mTachyonFileInputStream.close();
        }
        if (this.mHdfsInputStream != null) {
            this.mHdfsInputStream.close();
        }
        this.mClosed = true;
    }

    private void getHdfsInputStream() throws IOException {
        if (this.mHdfsInputStream == null) {
            FileSystem fs = this.mHdfsPath.getFileSystem(this.mHadoopConf);
            this.mHdfsInputStream = fs.open(this.mHdfsPath, this.mHadoopBufferSize);
            this.mHdfsInputStream.seek(this.mCurrentPosition);
        }
    }

    private void getHdfsInputStream(long position) throws IOException {
        if (this.mHdfsInputStream == null) {
            FileSystem fs = this.mHdfsPath.getFileSystem(this.mHadoopConf);
            this.mHdfsInputStream = fs.open(this.mHdfsPath, this.mHadoopBufferSize);
        }
        this.mHdfsInputStream.seek(position);
    }

    public long getPos() throws IOException {
        return this.mCurrentPosition;
    }

    @Override
    public int read() throws IOException {
        if (this.mClosed) {
            throw new IOException("Cannot read from a closed stream.");
        }
        if (this.mTachyonFileInputStream != null) {
            int ret = 0;
            try {
                ret = this.mTachyonFileInputStream.read();
                if (this.mStatistics != null && ret != -1) {
                    this.mStatistics.incrementBytesRead(1L);
                }
                ++this.mCurrentPosition;
                return ret;
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mTachyonFileInputStream.close();
                this.mTachyonFileInputStream = null;
            }
        }
        this.getHdfsInputStream();
        return this.readFromHdfsBuffer();
    }

    @Override
    public int read(byte[] b) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.mClosed) {
            throw new IOException("Cannot read from a closed stream.");
        }
        if (this.mTachyonFileInputStream != null) {
            int ret = 0;
            try {
                ret = this.mTachyonFileInputStream.read(b, off, len);
                if (this.mStatistics != null && ret != -1) {
                    this.mStatistics.incrementBytesRead((long)ret);
                }
                this.mCurrentPosition += (long)ret;
                return ret;
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mTachyonFileInputStream.close();
                this.mTachyonFileInputStream = null;
            }
        }
        this.getHdfsInputStream();
        int byteRead = this.readFromHdfsBuffer();
        if (byteRead == -1) {
            return -1;
        }
        b[off] = (byte)byteRead;
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(long position, byte[] buffer, int offset, int length) throws IOException {
        if (this.mClosed) {
            throw new IOException("Cannot read from a closed stream.");
        }
        int ret = -1;
        long oldPos = this.getPos();
        if (position < 0L || position >= this.mTachyonFile.length()) {
            return ret;
        }
        if (this.mTachyonFileInputStream != null) {
            try {
                this.mTachyonFileInputStream.seek(position);
                ret = this.mTachyonFileInputStream.read(buffer, offset, length);
                if (this.mStatistics != null && ret != -1) {
                    this.mStatistics.incrementBytesRead((long)ret);
                }
                int n = ret;
                return n;
            }
            finally {
                this.mTachyonFileInputStream.seek(oldPos);
            }
        }
        try {
            this.getHdfsInputStream(position);
            ret = this.mHdfsInputStream.read(buffer, offset, length);
            if (this.mStatistics != null && ret != -1) {
                this.mStatistics.incrementBytesRead((long)ret);
            }
            int n = ret;
            return n;
        }
        finally {
            if (this.mHdfsInputStream != null) {
                this.mHdfsInputStream.seek(oldPos);
            }
        }
    }

    private int readFromHdfsBuffer() throws IOException {
        if (this.mBufferPosition < this.mBufferLimit) {
            if (this.mStatistics != null) {
                this.mStatistics.incrementBytesRead(1L);
            }
            ++this.mCurrentPosition;
            return BufferUtils.byteToInt(this.mBuffer[this.mBufferPosition++]);
        }
        LOG.error("Reading from HDFS directly");
        while ((this.mBufferLimit = this.mHdfsInputStream.read(this.mBuffer)) == 0) {
            LOG.error("Read 0 bytes in readFromHdfsBuffer for " + this.mHdfsPath);
        }
        if (this.mBufferLimit == -1) {
            return -1;
        }
        this.mBufferPosition = 0;
        if (this.mStatistics != null) {
            this.mStatistics.incrementBytesRead(1L);
        }
        ++this.mCurrentPosition;
        return BufferUtils.byteToInt(this.mBuffer[this.mBufferPosition++]);
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        throw new IOException("Not supported");
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        throw new IOException("Not supported");
    }

    public void seek(long pos) throws IOException {
        if (pos == this.mCurrentPosition) {
            return;
        }
        if (pos < 0L) {
            throw new IOException("Seek position is negative: " + pos);
        }
        if (pos > this.mTachyonFile.length()) {
            throw new IOException("Seek position is past EOF: " + pos + ", fileSize = " + this.mTachyonFile.length());
        }
        if (this.mTachyonFileInputStream != null) {
            this.mTachyonFileInputStream.seek(pos);
        } else {
            this.getHdfsInputStream(pos);
            this.mBufferLimit = -1;
        }
        this.mCurrentPosition = pos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        throw new IOException("Not supported");
    }
}

