/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.MasterClientBase;
import tachyon.conf.TachyonConf;
import tachyon.org.apache.thrift.TException;
import tachyon.thrift.BlockMasterService;
import tachyon.thrift.Command;
import tachyon.thrift.NetAddress;

public final class WorkerBlockMasterClient
extends MasterClientBase {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private BlockMasterService.Client mClient = null;

    public WorkerBlockMasterClient(InetSocketAddress masterAddress, TachyonConf tachyonConf) {
        super(masterAddress, tachyonConf);
    }

    @Override
    protected String getServiceName() {
        return "BlockMaster";
    }

    @Override
    protected void afterConnect() {
        this.mClient = new BlockMasterService.Client(this.mProtocol);
    }

    public synchronized void commitBlock(long workerId, long usedBytesOnTier, int tier, long blockId, long length) throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                this.mClient.workerCommitBlock(workerId, usedBytesOnTier, tier, blockId, length);
                return;
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized long getId(NetAddress address) throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.workerGetWorkerId(address);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized Command heartbeat(long workerId, List<Long> usedBytesOnTiers, List<Long> removedBlocks, Map<Long, List<Long>> addedBlocks) throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                return this.mClient.workerHeartbeat(workerId, usedBytesOnTiers, removedBlocks, addedBlocks);
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }

    public synchronized void register(long workerId, List<Long> totalBytesOnTiers, List<Long> usedBytesOnTiers, Map<Long, List<Long>> currentBlocksOnTiers) throws IOException {
        int retry = 0;
        while (!this.mClosed && retry++ <= 30) {
            this.connect();
            try {
                this.mClient.workerRegister(workerId, totalBytesOnTiers, usedBytesOnTiers, currentBlocksOnTiers);
                return;
            }
            catch (TException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mConnected = false;
            }
        }
        throw new IOException("Failed after " + retry + " retries.");
    }
}

