/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.function.DefaultEntityResponseBuilder;
import org.springframework.web.servlet.function.DefaultRenderingResponseBuilder;
import org.springframework.web.servlet.function.ErrorHandlingServerResponse;
import org.springframework.web.servlet.function.ServerResponse;

class DefaultServerResponseBuilder
implements ServerResponse.BodyBuilder {
    private final int statusCode;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, Cookie> cookies = new LinkedMultiValueMap();

    public DefaultServerResponseBuilder(ServerResponse other) {
        Assert.notNull((Object)other, (String)"ServerResponse must not be null");
        this.statusCode = other instanceof AbstractServerResponse ? ((AbstractServerResponse)other).statusCode : other.statusCode().value();
        this.headers.addAll((MultiValueMap)other.headers());
        this.cookies.addAll(other.cookies());
    }

    public DefaultServerResponseBuilder(HttpStatus status) {
        Assert.notNull((Object)status, (String)"HttpStatus must not be null");
        this.statusCode = status.value();
    }

    public DefaultServerResponseBuilder(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public ServerResponse.BodyBuilder header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cookie(Cookie cookie) {
        Assert.notNull((Object)cookie, (String)"Cookie must not be null");
        this.cookies.add((Object)cookie.getName(), (Object)cookie);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cookies(Consumer<MultiValueMap<String, Cookie>> cookiesConsumer) {
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder allow(HttpMethod ... allowedMethods) {
        this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder allow(Set<HttpMethod> allowedMethods) {
        this.headers.setAllow(allowedMethods);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder contentLength(long contentLength) {
        this.headers.setContentLength(contentLength);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder contentType(MediaType contentType) {
        this.headers.setContentType(contentType);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder eTag(String etag) {
        if (!etag.startsWith("\"") && !etag.startsWith("W/\"")) {
            etag = "\"" + etag;
        }
        if (!etag.endsWith("\"")) {
            etag = etag + "\"";
        }
        this.headers.setETag(etag);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder lastModified(ZonedDateTime lastModified) {
        this.headers.setLastModified(lastModified);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder lastModified(Instant lastModified) {
        this.headers.setLastModified(lastModified);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cacheControl(CacheControl cacheControl) {
        this.headers.setCacheControl(cacheControl);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder varyBy(String ... requestHeaders) {
        this.headers.setVary(Arrays.asList(requestHeaders));
        return this;
    }

    @Override
    public ServerResponse build() {
        return this.build((request, response) -> null);
    }

    @Override
    public ServerResponse build(BiFunction<HttpServletRequest, HttpServletResponse, ModelAndView> writeFunction) {
        return new WriterFunctionResponse(this.statusCode, this.headers, this.cookies, writeFunction);
    }

    @Override
    public ServerResponse body(Object body2) {
        return DefaultEntityResponseBuilder.fromObject(body2).status(this.statusCode).headers((HttpHeaders headers) -> headers.putAll((Map)this.headers)).cookies((MultiValueMap<String, Cookie> cookies) -> cookies.addAll(this.cookies)).build();
    }

    @Override
    public <T> ServerResponse body(T body2, ParameterizedTypeReference<T> bodyType) {
        return DefaultEntityResponseBuilder.fromObject(body2, bodyType).status(this.statusCode).headers((HttpHeaders headers) -> headers.putAll((Map)this.headers)).cookies((MultiValueMap<String, Cookie> cookies) -> cookies.addAll(this.cookies)).build();
    }

    @Override
    public ServerResponse render(String name, Object ... modelAttributes) {
        return new DefaultRenderingResponseBuilder(name).status(this.statusCode).headers((HttpHeaders headers) -> headers.putAll((Map)this.headers)).cookies((MultiValueMap<String, Cookie> cookies) -> cookies.addAll(this.cookies)).modelAttributes(modelAttributes).build();
    }

    @Override
    public ServerResponse render(String name, Map<String, ?> model) {
        return new DefaultRenderingResponseBuilder(name).status(this.statusCode).headers((HttpHeaders headers) -> headers.putAll((Map)this.headers)).cookies((MultiValueMap<String, Cookie> cookies) -> cookies.addAll(this.cookies)).modelAttributes(model).build();
    }

    private static class WriterFunctionResponse
    extends AbstractServerResponse {
        private final BiFunction<HttpServletRequest, HttpServletResponse, ModelAndView> writeFunction;

        public WriterFunctionResponse(int statusCode, HttpHeaders headers, MultiValueMap<String, Cookie> cookies, BiFunction<HttpServletRequest, HttpServletResponse, ModelAndView> writeFunction) {
            super(statusCode, headers, cookies);
            Assert.notNull(writeFunction, (String)"WriteFunction must not be null");
            this.writeFunction = writeFunction;
        }

        @Override
        protected ModelAndView writeToInternal(HttpServletRequest request, HttpServletResponse response, ServerResponse.Context context) {
            return this.writeFunction.apply(request, response);
        }
    }

    static abstract class AbstractServerResponse
    extends ErrorHandlingServerResponse {
        private static final Set<HttpMethod> SAFE_METHODS = EnumSet.of(HttpMethod.GET, HttpMethod.HEAD);
        final int statusCode;
        private final HttpHeaders headers;
        private final MultiValueMap<String, Cookie> cookies;

        protected AbstractServerResponse(int statusCode, HttpHeaders headers, MultiValueMap<String, Cookie> cookies) {
            this.statusCode = statusCode;
            this.headers = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers);
            this.cookies = CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)new LinkedMultiValueMap(cookies));
        }

        @Override
        public final HttpStatus statusCode() {
            return HttpStatus.valueOf((int)this.statusCode);
        }

        @Override
        public int rawStatusCode() {
            return this.statusCode;
        }

        @Override
        public final HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public MultiValueMap<String, Cookie> cookies() {
            return this.cookies;
        }

        @Override
        public ModelAndView writeTo(HttpServletRequest request, HttpServletResponse response, ServerResponse.Context context) throws ServletException, IOException {
            try {
                this.writeStatusAndHeaders(response);
                long lastModified = this.headers().getLastModified();
                ServletWebRequest servletWebRequest = new ServletWebRequest(request, response);
                HttpMethod httpMethod = HttpMethod.resolve((String)request.getMethod());
                if (SAFE_METHODS.contains(httpMethod) && servletWebRequest.checkNotModified(this.headers().getETag(), lastModified)) {
                    return null;
                }
                return this.writeToInternal(request, response, context);
            }
            catch (Throwable throwable) {
                return this.handleError(throwable, request, response, context);
            }
        }

        private void writeStatusAndHeaders(HttpServletResponse response) {
            response.setStatus(this.statusCode);
            this.writeHeaders(response);
            this.writeCookies(response);
        }

        private void writeHeaders(HttpServletResponse servletResponse) {
            this.headers.forEach((headerName, headerValues) -> {
                for (String headerValue : headerValues) {
                    servletResponse.addHeader(headerName, headerValue);
                }
            });
            if (servletResponse.getContentType() == null && this.headers.getContentType() != null) {
                servletResponse.setContentType(this.headers.getContentType().toString());
            }
            if (servletResponse.getCharacterEncoding() == null && this.headers.getContentType() != null && this.headers.getContentType().getCharset() != null) {
                servletResponse.setCharacterEncoding(this.headers.getContentType().getCharset().name());
            }
        }

        private void writeCookies(HttpServletResponse servletResponse) {
            this.cookies.values().stream().flatMap(Collection::stream).forEach(arg_0 -> ((HttpServletResponse)servletResponse).addCookie(arg_0));
        }

        @Nullable
        protected abstract ModelAndView writeToInternal(HttpServletRequest var1, HttpServletResponse var2, ServerResponse.Context var3) throws ServletException, IOException;
    }
}

