/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedClasses;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.log.LogMessage;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.TypeSpec;
import org.springframework.javapoet.WildcardTypeName;
import org.springframework.test.context.aot.AotTestContextInitializers;
import org.springframework.util.MultiValueMap;

class AotTestContextInitializersCodeGenerator {
    private static final Log logger = LogFactory.getLog(AotTestContextInitializersCodeGenerator.class);
    private static final ParameterizedTypeName CONTEXT_INITIALIZER = ParameterizedTypeName.get((ClassName)ClassName.get(ApplicationContextInitializer.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(ConfigurableApplicationContext.class)});
    private static final ParameterizedTypeName CONTEXT_INITIALIZER_SUPPLIER = ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{CONTEXT_INITIALIZER});
    private static final TypeName CONTEXT_INITIALIZER_SUPPLIER_MAP = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), CONTEXT_INITIALIZER_SUPPLIER});
    private static final ParameterizedTypeName CONTEXT_INITIALIZER_CLASS = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ApplicationContextInitializer.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}))});
    private static final TypeName CONTEXT_INITIALIZER_CLASS_MAP = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), CONTEXT_INITIALIZER_CLASS});
    private static final String GENERATED_SUFFIX = "Generated";
    static final String GENERATED_MAPPINGS_CLASS_NAME = AotTestContextInitializers.class.getName() + "__Generated";
    static final String GET_CONTEXT_INITIALIZERS_METHOD_NAME = "getContextInitializers";
    static final String GET_CONTEXT_INITIALIZER_CLASSES_METHOD_NAME = "getContextInitializerClasses";
    private final MultiValueMap<ClassName, Class<?>> initializerClassMappings;
    private final GeneratedClass generatedClass;

    AotTestContextInitializersCodeGenerator(MultiValueMap<ClassName, Class<?>> initializerClassMappings, GeneratedClasses generatedClasses) {
        this.initializerClassMappings = initializerClassMappings;
        this.generatedClass = generatedClasses.addForFeature(GENERATED_SUFFIX, this::generateType);
    }

    GeneratedClass getGeneratedClass() {
        return this.generatedClass;
    }

    private void generateType(TypeSpec.Builder type) {
        logger.debug((Object)LogMessage.format((String)"Generating AOT test mappings in %s", (Object)this.generatedClass.getName().reflectionName()));
        type.addJavadoc("Generated mappings for {@link $T}.", new Object[]{AotTestContextInitializers.class});
        type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        type.addMethod(this.contextInitializersMappingMethod());
        type.addMethod(this.contextInitializerClassesMappingMethod());
    }

    private MethodSpec contextInitializersMappingMethod() {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)GET_CONTEXT_INITIALIZERS_METHOD_NAME);
        method.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        method.returns(CONTEXT_INITIALIZER_SUPPLIER_MAP);
        method.addCode(this.generateContextInitializersMappingCode());
        return method.build();
    }

    private CodeBlock generateContextInitializersMappingCode() {
        CodeBlock.Builder code = CodeBlock.builder();
        code.addStatement("$T map = new $T<>()", new Object[]{CONTEXT_INITIALIZER_SUPPLIER_MAP, HashMap.class});
        this.initializerClassMappings.forEach((className, testClasses) -> {
            List<String> testClassNames = testClasses.stream().map(Class::getName).toList();
            logger.trace((Object)LogMessage.format((String)"Generating mapping from AOT context initializer supplier [%s] to test classes %s", (Object)className.reflectionName(), testClassNames));
            testClassNames.forEach(testClassName -> code.addStatement("map.put($S, () -> new $T())", new Object[]{testClassName, className}));
        });
        code.addStatement("return map", new Object[0]);
        return code.build();
    }

    private MethodSpec contextInitializerClassesMappingMethod() {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)GET_CONTEXT_INITIALIZER_CLASSES_METHOD_NAME);
        method.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        method.returns(CONTEXT_INITIALIZER_CLASS_MAP);
        method.addCode(this.generateContextInitializerClassesMappingCode());
        return method.build();
    }

    private CodeBlock generateContextInitializerClassesMappingCode() {
        CodeBlock.Builder code = CodeBlock.builder();
        code.addStatement("$T map = new $T<>()", new Object[]{CONTEXT_INITIALIZER_CLASS_MAP, HashMap.class});
        this.initializerClassMappings.forEach((className, testClasses) -> {
            List<String> testClassNames = testClasses.stream().map(Class::getName).toList();
            logger.trace((Object)LogMessage.format((String)"Generating mapping from AOT context initializer class [%s] to test classes %s", (Object)className.reflectionName(), testClassNames));
            testClassNames.forEach(testClassName -> code.addStatement("map.put($S, $T.class)", new Object[]{testClassName, className}));
        });
        code.addStatement("return map", new Object[0]);
        return code.build();
    }
}

