/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.util.Assert;

abstract class ApplicationContextInitializerUtils {
    private static final Log logger = LogFactory.getLog(ApplicationContextInitializerUtils.class);

    private ApplicationContextInitializerUtils() {
    }

    static Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> resolveInitializerClasses(List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be empty");
        HashSet<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses = new HashSet<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>>();
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Processing context initializers for context configuration attributes %s", configAttributes));
            }
            initializerClasses.addAll(Arrays.asList(configAttributes.getInitializers()));
            if (configAttributes.isInheritInitializers()) continue;
            break;
        }
        return initializerClasses;
    }
}

