/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import javax.xml.transform.Source;
import org.hamcrest.Matcher;
import org.springframework.http.MediaType;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.test.util.XmlExpectationsHelper;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentResultMatchers {
    private final XmlExpectationsHelper xmlHelper = new XmlExpectationsHelper();

    protected ContentResultMatchers() {
    }

    public ResultMatcher contentType(String contentType) {
        return this.contentType(MediaType.parseMediaType((String)contentType));
    }

    public ResultMatcher contentType(final MediaType contentType) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String actual = result.getResponse().getContentType();
                AssertionErrors.assertTrue("Content type not set", actual != null);
                AssertionErrors.assertEquals("Content type", contentType, MediaType.parseMediaType((String)actual));
            }
        };
    }

    public ResultMatcher encoding(final String characterEncoding) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                String actual = result.getResponse().getCharacterEncoding();
                AssertionErrors.assertEquals("Character encoding", characterEncoding, actual);
            }
        };
    }

    public ResultMatcher string(final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                MatcherAssertionErrors.assertThat("Response content", result.getResponse().getContentAsString(), matcher);
            }
        };
    }

    public ResultMatcher string(final String expectedContent) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertEquals("Response content", expectedContent, result.getResponse().getContentAsString());
            }
        };
    }

    public ResultMatcher bytes(final byte[] expectedContent) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertEquals("Response content", expectedContent, result.getResponse().getContentAsByteArray());
            }
        };
    }

    public ResultMatcher xml(final String xmlContent) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                ContentResultMatchers.this.xmlHelper.assertXmlEqual(xmlContent, content);
            }
        };
    }

    public ResultMatcher node(final Matcher<? super Node> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                ContentResultMatchers.this.xmlHelper.assertNode(content, (Matcher<? super Node>)matcher);
            }
        };
    }

    public ResultMatcher source(final Matcher<? super Source> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                ContentResultMatchers.this.xmlHelper.assertSource(content, (Matcher<? super Source>)matcher);
            }
        };
    }
}

