/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.messaging.simp.SimpMessageType;

public enum StompCommand {
    CONNECT,
    STOMP,
    SEND,
    SUBSCRIBE,
    UNSUBSCRIBE,
    ACK,
    NACK,
    BEGIN,
    COMMIT,
    ABORT,
    DISCONNECT,
    CONNECTED,
    MESSAGE,
    RECEIPT,
    ERROR;

    private static Map<StompCommand, SimpMessageType> messageTypes;
    private static Collection<StompCommand> destinationRequired;
    private static Collection<StompCommand> subscriptionIdRequired;
    private static Collection<StompCommand> contentLengthRequired;
    private static Collection<StompCommand> bodyAllowed;

    public SimpMessageType getMessageType() {
        SimpMessageType type = messageTypes.get((Object)this);
        return type != null ? type : SimpMessageType.OTHER;
    }

    public boolean requiresDestination() {
        return destinationRequired.contains((Object)this);
    }

    public boolean requiresSubscriptionId() {
        return subscriptionIdRequired.contains((Object)this);
    }

    public boolean requiresContentLength() {
        return contentLengthRequired.contains((Object)this);
    }

    public boolean isBodyAllowed() {
        return bodyAllowed.contains((Object)this);
    }

    static {
        messageTypes = new HashMap<StompCommand, SimpMessageType>();
        destinationRequired = Arrays.asList(SEND, SUBSCRIBE, MESSAGE);
        subscriptionIdRequired = Arrays.asList(SUBSCRIBE, UNSUBSCRIBE, MESSAGE);
        contentLengthRequired = Arrays.asList(SEND, MESSAGE, ERROR);
        bodyAllowed = Arrays.asList(SEND, MESSAGE, ERROR);
        messageTypes.put(CONNECT, SimpMessageType.CONNECT);
        messageTypes.put(STOMP, SimpMessageType.CONNECT);
        messageTypes.put(SEND, SimpMessageType.MESSAGE);
        messageTypes.put(MESSAGE, SimpMessageType.MESSAGE);
        messageTypes.put(SUBSCRIBE, SimpMessageType.SUBSCRIBE);
        messageTypes.put(UNSUBSCRIBE, SimpMessageType.UNSUBSCRIBE);
        messageTypes.put(DISCONNECT, SimpMessageType.DISCONNECT);
    }
}

