/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UserProfile;
import org.springframework.web.servlet.view.AbstractView;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericConnectionStatusView
extends AbstractView {
    private final String providerId;
    private final String providerDisplayName;

    public GenericConnectionStatusView(String providerId, String providerDisplayName) {
        this.providerId = providerId;
        this.providerDisplayName = providerDisplayName;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setHeader("Content-Type", "text/html");
        response.getWriter().write(GenericConnectionStatusHtmlCreator.generateConnectionViewHtml(this.providerDisplayName, this.providerId, this.getProfileIfConnected(model)));
    }

    private UserProfile getProfileIfConnected(Map<String, Object> model) {
        List connections = (List)model.get("connections");
        if (connections != null) {
            for (Connection connection : connections) {
                if (!connection.getKey().getProviderId().equals(this.providerId)) continue;
                return connection.fetchUserProfile();
            }
        }
        return null;
    }

    public static class GenericConnectionStatusHtmlCreator {
        public static String generateConnectionViewHtml(String providerDisplayName, String providerId, UserProfile profile) {
            String escProviderDisplayName = GenericConnectionStatusHtmlCreator.escape(providerDisplayName);
            StringBuilder builder = new StringBuilder();
            if (profile == null) {
                builder.append("<h3>Connect to " + escProviderDisplayName + "</h3>");
                builder.append("<form action=\"/connect/");
                try {
                    String escProviderId = UriUtils.encodePath((String)providerId, (String)"UTF-8");
                    builder.append(escProviderId);
                }
                catch (UnsupportedEncodingException escProviderId) {
                    // empty catch block
                }
                builder.append("\" method=\"POST\">");
                builder.append("<div class=\"formInfo\">");
                builder.append("<p>You aren't connected to ");
                builder.append(escProviderDisplayName);
                builder.append(" yet. Click the button to connect with your ");
                builder.append(escProviderDisplayName);
                builder.append(" account.</p>");
                builder.append("</div>");
                builder.append("<p><button type=\"submit\">Connect to ");
                builder.append(escProviderDisplayName);
                builder.append("</button></p>");
                builder.append("</form>");
            } else {
                String escProfileName = GenericConnectionStatusHtmlCreator.escape(profile.getName());
                builder.append("<h3>Connected to ");
                builder.append(escProviderDisplayName);
                builder.append("</h3>");
                builder.append("<p>Hello, ");
                builder.append(escProfileName);
                builder.append("!</p><p>You are now connected to ");
                builder.append(escProviderDisplayName);
                String username = profile.getUsername();
                if (username != null) {
                    builder.append(" as ");
                    builder.append(GenericConnectionStatusHtmlCreator.escape(username));
                }
                builder.append(".</p>");
            }
            return builder.toString();
        }

        private static String escape(String in) {
            return HtmlUtils.htmlEscape((String)in).replaceAll("\\{", "&#123;").replaceAll("\\}", "&#125;");
        }
    }
}

