/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.connect;

import java.util.Collections;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.OAuth2Template;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookOAuth2Template
extends OAuth2Template {
    public FacebookOAuth2Template(String clientId, String clientSecret) {
        super(clientId, clientSecret, "https://graph.facebook.com/oauth/authorize", "https://graph.facebook.com/oauth/access_token");
    }

    protected RestTemplate createRestTemplate() {
        RestTemplate restTemplate = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
        FormHttpMessageConverter messageConverter = new FormHttpMessageConverter(){

            public boolean canRead(Class<?> clazz, MediaType mediaType) {
                return true;
            }
        };
        restTemplate.setMessageConverters(Collections.singletonList(messageConverter));
        return restTemplate;
    }

    protected AccessGrant postForAccessGrant(String accessTokenUrl, MultiValueMap<String, String> parameters) {
        MultiValueMap response = (MultiValueMap)this.getRestTemplate().postForObject(accessTokenUrl, parameters, MultiValueMap.class, new Object[0]);
        String expires = (String)response.getFirst((Object)"expires");
        return new AccessGrant((String)response.getFirst((Object)"access_token"), null, null, expires != null ? Integer.valueOf(expires) : null);
    }
}

