/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard;

import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.ParameterDescription;
import org.springframework.shell.ParameterMissingResolutionException;
import org.springframework.shell.ParameterResolver;
import org.springframework.shell.UnfinishedParameterResolutionException;
import org.springframework.shell.Utils;
import org.springframework.shell.ValueResult;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import org.springframework.shell.standard.ValueProvider;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;

@Component
public class StandardParameterResolver
implements ParameterResolver {
    private final ConversionService conversionService;
    private Collection<ValueProvider> valueProviders = new HashSet<ValueProvider>();
    private final Map<CacheKey, Map<Parameter, ParameterRawValue>> parameterCache = new ConcurrentReferenceHashMap();
    private Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    @Autowired
    public StandardParameterResolver(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Autowired(required=false)
    public void setValueProviders(Collection<ValueProvider> valueProviders) {
        this.valueProviders = valueProviders;
    }

    @Autowired(required=false)
    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validator = validatorFactory.getValidator();
    }

    public boolean supports(MethodParameter parameter) {
        boolean optOut = parameter.hasParameterAnnotation(ShellOption.class) && ((ShellOption)parameter.getParameterAnnotation(ShellOption.class)).optOut();
        return !optOut && parameter.getMethodAnnotation(ShellMethod.class) != null;
    }

    public ValueResult resolve(MethodParameter methodParameter, List<String> wordsBuffer) {
        String prefix = this.prefixForMethod(methodParameter.getMethod());
        List words = wordsBuffer.stream().filter(w -> !w.isEmpty()).collect(Collectors.toList());
        CacheKey cacheKey = new CacheKey(methodParameter.getMethod(), wordsBuffer);
        this.parameterCache.clear();
        Map resolved = this.parameterCache.computeIfAbsent(cacheKey, k -> {
            Parameter parameter;
            HashMap<Parameter, ParameterRawValue> result = new HashMap<Parameter, ParameterRawValue>();
            HashMap<String, String> namedParameters = new HashMap<String, String>();
            ArrayList<Integer> unusedWords = new ArrayList<Integer>();
            Set<String> possibleKeys = this.gatherAllPossibleKeys(methodParameter.getMethod());
            for (int i = 0; i < words.size(); ++i) {
                int from = i;
                String word = (String)words.get(i);
                if (possibleKeys.contains(word)) {
                    String key = word;
                    parameter = this.lookupParameterForKey(methodParameter.getMethod(), key);
                    int arity = this.getArity(parameter);
                    if (i + 1 + arity > words.size()) {
                        String input = words.subList(i, words.size()).stream().collect(Collectors.joining(" "));
                        throw new UnfinishedParameterResolutionException(this.describe(Utils.createMethodParameter((Parameter)parameter)).findFirst().get(), (CharSequence)input);
                    }
                    Assert.isTrue((i + 1 + arity <= words.size() ? 1 : 0) != 0, (String)String.format("Not enough input for parameter '%s'", word));
                    String raw = words.subList(i + 1, i + 1 + arity).stream().collect(Collectors.joining(","));
                    Assert.isTrue((!namedParameters.containsKey(key) ? 1 : 0) != 0, (String)String.format("Parameter for '%s' has already been specified", word));
                    namedParameters.put(key, raw);
                    if (arity == 0) {
                        boolean defaultValue = this.booleanDefaultValue(parameter);
                        result.put(parameter, ParameterRawValue.explicit(String.valueOf(!defaultValue), key, from, from));
                        continue;
                    }
                    result.put(parameter, ParameterRawValue.explicit(raw, key, from, i += arity));
                    continue;
                }
                unusedWords.add(i);
            }
            int offset = 0;
            Parameter[] parameters = methodParameter.getMethod().getParameters();
            int parametersLength = parameters.length;
            for (int i = 0; i < parametersLength; ++i) {
                parameter = parameters[i];
                Collection keys = this.getKeysForParameter(methodParameter.getMethod(), i).collect(Collectors.toSet());
                HashSet<String> copy = new HashSet<String>(keys);
                copy.retainAll(namedParameters.keySet());
                if (copy.isEmpty()) {
                    int arity = this.getArity(parameter);
                    if (arity > 0 && offset + arity <= unusedWords.size()) {
                        String raw = unusedWords.subList(offset, offset + arity).stream().map(index -> (String)words.get((int)index)).collect(Collectors.joining(","));
                        int from = (Integer)unusedWords.get(offset);
                        int to = from + arity - 1;
                        result.put(parameter, ParameterRawValue.explicit(raw, null, from, to));
                        offset += arity;
                        continue;
                    }
                    Optional<String> defaultValue = this.defaultValueFor(parameter);
                    defaultValue.ifPresent(value -> result.put(parameter, ParameterRawValue.implicit(value, null, null, null)));
                    continue;
                }
                if (copy.size() <= 1) continue;
                throw new IllegalArgumentException("Named parameter has been specified multiple times via " + this.quote(copy));
            }
            Assert.isTrue((offset == unusedWords.size() ? 1 : 0) != 0, (String)("Too many arguments: the following could not be mapped to parameters: " + unusedWords.subList(offset, unusedWords.size()).stream().map(index -> (String)words.get((int)index)).collect(Collectors.joining(" ", "'", "'"))));
            return result;
        });
        Parameter param = methodParameter.getMethod().getParameters()[methodParameter.getParameterIndex()];
        if (!resolved.containsKey(param)) {
            throw new ParameterMissingResolutionException(this.describe(methodParameter).findFirst().get());
        }
        ParameterRawValue parameterRawValue = (ParameterRawValue)resolved.get(param);
        Object value = this.convertRawValue(parameterRawValue, methodParameter);
        BitSet wordsUsed = this.getWordsUsed(parameterRawValue);
        BitSet wordsUsedForValue = this.getWordsUsedForValue(parameterRawValue);
        return new ValueResult(methodParameter, value, wordsUsed, wordsUsedForValue);
    }

    private BitSet getWordsUsed(ParameterRawValue parameterRawValue) {
        if (parameterRawValue.from != null) {
            BitSet wordsUsed = new BitSet();
            wordsUsed.set((int)parameterRawValue.from, parameterRawValue.to + 1);
            return wordsUsed;
        }
        return null;
    }

    private BitSet getWordsUsedForValue(ParameterRawValue parameterRawValue) {
        if (parameterRawValue.from != null) {
            BitSet wordsUsedForValue = new BitSet();
            wordsUsedForValue.set((int)parameterRawValue.from, parameterRawValue.to + 1);
            if (parameterRawValue.key != null) {
                wordsUsedForValue.clear(parameterRawValue.from);
            }
            return wordsUsedForValue;
        }
        return null;
    }

    private Object convertRawValue(ParameterRawValue parameterRawValue, MethodParameter methodParameter) {
        String s = parameterRawValue.value;
        if ("__NULL__".equals(s)) {
            return null;
        }
        return this.conversionService.convert((Object)s, TypeDescriptor.valueOf(String.class), new TypeDescriptor(methodParameter));
    }

    private Set<String> gatherAllPossibleKeys(Method method) {
        return Arrays.stream(method.getParameters()).flatMap(this::getKeysForParameter).collect(Collectors.toSet());
    }

    private String prefixForMethod(Executable method) {
        return method.getAnnotation(ShellMethod.class).prefix();
    }

    private Optional<String> defaultValueFor(Parameter parameter) {
        ShellOption option = parameter.getAnnotation(ShellOption.class);
        if (option != null && !"__NONE__".equals(option.defaultValue())) {
            return Optional.of(option.defaultValue());
        }
        if (this.getArity(parameter) == 0) {
            return Optional.of("false");
        }
        return Optional.empty();
    }

    private boolean booleanDefaultValue(Parameter parameter) {
        ShellOption option = parameter.getAnnotation(ShellOption.class);
        if (option != null && !"__NONE__".equals(option.defaultValue())) {
            return Boolean.parseBoolean(option.defaultValue());
        }
        return false;
    }

    public Stream<ParameterDescription> describe(MethodParameter parameter) {
        Parameter jlrParameter = parameter.getMethod().getParameters()[parameter.getParameterIndex()];
        int arity = this.getArity(jlrParameter);
        Class type = parameter.getParameterType();
        ShellOption option = jlrParameter.getAnnotation(ShellOption.class);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arity; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(arity > 1 ? Utils.unCamelify((CharSequence)this.removeMultiplicityFromType(parameter).getSimpleName()) : Utils.unCamelify((CharSequence)type.getSimpleName()));
        }
        ParameterDescription result = ParameterDescription.outOf((MethodParameter)parameter);
        result.formal(sb.toString());
        if (option != null) {
            result.help(option.help());
            Optional<String> defaultValue = this.defaultValueFor(jlrParameter);
            if (defaultValue.isPresent()) {
                result.defaultValue(defaultValue.map(dv -> dv.equals("__NULL__") ? "<none>" : dv).get());
            }
        }
        result.keys(this.getKeysForParameter(parameter.getMethod(), parameter.getParameterIndex()).collect(Collectors.toList())).mandatoryKey(false);
        MethodDescriptor constraintsForMethod = this.validator.getConstraintsForClass(parameter.getDeclaringClass()).getConstraintsForMethod(parameter.getMethod().getName(), (Class[])parameter.getMethod().getParameterTypes());
        if (constraintsForMethod != null) {
            ParameterDescriptor constraintsDescriptor = (ParameterDescriptor)constraintsForMethod.getParameterDescriptors().get(parameter.getParameterIndex());
            result.elementDescriptor((ElementDescriptor)constraintsDescriptor);
        }
        return Stream.of(result);
    }

    public List<CompletionProposal> complete(MethodParameter methodParameter, CompletionContext context) {
        boolean set;
        UnfinishedParameterResolutionException unfinished = null;
        ParameterRawValue parameterRawValue = null;
        int arity = 1;
        try {
            this.resolve(methodParameter, context.getWords());
            CacheKey cacheKey = new CacheKey(methodParameter.getMethod(), context.getWords());
            Parameter parameter = methodParameter.getMethod().getParameters()[methodParameter.getParameterIndex()];
            arity = this.getArity(parameter);
            parameterRawValue = this.parameterCache.get(cacheKey).get(parameter);
            set = parameterRawValue.explicit;
        }
        catch (ParameterMissingResolutionException e) {
            set = false;
        }
        catch (UnfinishedParameterResolutionException e) {
            if (e.getParameterDescription().parameter().equals((Object)methodParameter)) {
                unfinished = e;
                set = false;
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            return this.argumentKeysThatStartWithContextPrefix(methodParameter, context);
        }
        if (!set) {
            if (unfinished == null) {
                return this.argumentKeysThatStartWithContextPrefix(methodParameter, context);
            }
            return this.valueCompletions(methodParameter, context);
        }
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        Object value = this.convertRawValue(parameterRawValue, methodParameter);
        if (value instanceof Collection && ((Collection)value).size() == arity || ObjectUtils.isArray((Object)value) && Array.getLength(value) == arity) {
            return result;
        }
        if (!context.currentWord().equals("")) {
            result.addAll(this.valueCompletions(methodParameter, context));
        }
        if (parameterRawValue.positional()) {
            result.addAll(this.argumentKeysThatStartWithContextPrefix(methodParameter, context));
        }
        return result;
    }

    private List<CompletionProposal> valueCompletions(MethodParameter methodParameter, CompletionContext completionContext) {
        return this.valueProviders.stream().filter(vp -> vp.supports(methodParameter, completionContext)).map(vp -> vp.complete(methodParameter, completionContext, null)).findFirst().orElseGet(() -> Collections.emptyList());
    }

    private List<CompletionProposal> argumentKeysThatStartWithContextPrefix(MethodParameter methodParameter, CompletionContext context) {
        String prefix = context.currentWordUpToCursor() != null ? context.currentWordUpToCursor() : "";
        return this.describe(methodParameter).flatMap(pd -> pd.keys().stream()).filter(k -> k.startsWith(prefix)).map(CompletionProposal::new).collect(Collectors.toList());
    }

    private Class<?> removeMultiplicityFromType(MethodParameter parameter) {
        Class parameterType = parameter.getParameterType();
        if (parameterType.isArray()) {
            return parameterType.getComponentType();
        }
        if (Collection.class.isAssignableFrom(parameterType)) {
            return parameter.getNestedParameterType();
        }
        throw new RuntimeException("For " + parameter + " (with arity > 1) expected an array/collection type");
    }

    private String quote(Collection<String> keys) {
        return keys.stream().collect(Collectors.joining(", ", "'", "'"));
    }

    private int getArity(Parameter parameter) {
        ShellOption option = parameter.getAnnotation(ShellOption.class);
        int inferred = parameter.getType() == Boolean.TYPE || parameter.getType() == Boolean.class ? 0 : 1;
        return option != null && option.arity() != -1 ? option.arity() : inferred;
    }

    private Stream<String> getKeysForParameter(Method method, int index) {
        Parameter p = method.getParameters()[index];
        return this.getKeysForParameter(p);
    }

    private Stream<String> getKeysForParameter(Parameter p) {
        Executable method = p.getDeclaringExecutable();
        String prefix = this.prefixForMethod(method);
        ShellOption option = p.getAnnotation(ShellOption.class);
        if (option != null && option.value().length > 0) {
            return Arrays.stream(option.value());
        }
        return Stream.of(prefix + Utils.unCamelify((CharSequence)Utils.createMethodParameter((Parameter)p).getParameterName()));
    }

    private Parameter lookupParameterForKey(Method method, String key) {
        Parameter[] parameters = method.getParameters();
        int parametersLength = parameters.length;
        for (int i = 0; i < parametersLength; ++i) {
            Parameter p = parameters[i];
            if (!this.getKeysForParameter(method, i).anyMatch(k -> k.equals(key))) continue;
            return p;
        }
        throw new IllegalArgumentException(String.format("Could not look up parameter for '%s' in %s", key, method));
    }

    private static class ParameterRawValue {
        private CompletionContext context;
        private Integer from;
        private Integer to;
        private Integer keyIndex;
        private final String value;
        private final boolean explicit;
        private final String key;

        private ParameterRawValue(String value, boolean explicit, String key, Integer from, Integer to) {
            this.value = value;
            this.explicit = explicit;
            this.key = key;
            this.from = from;
            this.to = to;
        }

        public static ParameterRawValue explicit(String value, String key, Integer from, Integer to) {
            return new ParameterRawValue(value, true, key, from, to);
        }

        public static ParameterRawValue implicit(String value, String key, Integer from, Integer to) {
            return new ParameterRawValue(value, false, key, from, to);
        }

        public boolean positional() {
            return this.key == null;
        }

        public String toString() {
            return "ParameterRawValue{value='" + this.value + '\'' + ", explicit=" + this.explicit + ", key='" + this.key + '\'' + ", from=" + this.from + ", to=" + this.to + '}';
        }
    }

    private static class CacheKey {
        private final Method method;
        private final List<String> words;

        private CacheKey(Method method, List<String> words) {
            this.method = method;
            this.words = words;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.method, cacheKey.method) && Objects.equals(this.words, cacheKey.words);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.words);
        }

        public String toString() {
            return this.method.getName() + " " + this.words;
        }
    }
}

