/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.util.function.Function;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.web.server.DefaultOidcLogoutTokenValidatorFactory;
import org.springframework.security.config.web.server.OidcBackChannelLogoutAuthentication;
import org.springframework.security.config.web.server.OidcLogoutAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.oidc.authentication.ReactiveOidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.oidc.authentication.logout.OidcLogoutToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoderFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

final class OidcBackChannelLogoutReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private ReactiveJwtDecoderFactory<ClientRegistration> logoutTokenDecoderFactory;

    OidcBackChannelLogoutReactiveAuthenticationManager() {
        ReactiveOidcIdTokenDecoderFactory logoutTokenDecoderFactory = new ReactiveOidcIdTokenDecoderFactory();
        logoutTokenDecoderFactory.setJwtValidatorFactory((Function)new DefaultOidcLogoutTokenValidatorFactory());
        this.logoutTokenDecoderFactory = logoutTokenDecoderFactory;
    }

    public Mono<Authentication> authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication instanceof OidcLogoutAuthenticationToken)) {
            return Mono.empty();
        }
        OidcLogoutAuthenticationToken token = (OidcLogoutAuthenticationToken)authentication;
        String logoutToken = token.getLogoutToken();
        ClientRegistration registration = token.getClientRegistration();
        return this.decode(registration, logoutToken).map(jwt -> OidcLogoutToken.withTokenValue((String)logoutToken).claims(claims -> claims.putAll(jwt.getClaims())).build()).map(OidcBackChannelLogoutAuthentication::new);
    }

    private Mono<Jwt> decode(ClientRegistration registration, String token) {
        ReactiveJwtDecoder logoutTokenDecoder = this.logoutTokenDecoderFactory.createDecoder((Object)registration);
        return logoutTokenDecoder.decode(token).onErrorResume(Exception.class, ex -> {
            if (ex instanceof BadJwtException) {
                OAuth2Error error = new OAuth2Error("invalid_request", ex.getMessage(), "https://openid.net/specs/openid-connect-backchannel-1_0.html#Validation");
                return Mono.error((Throwable)new OAuth2AuthenticationException(error, (Throwable)ex));
            }
            return Mono.error((Throwable)new AuthenticationServiceException(ex.getMessage(), (Throwable)ex));
        });
    }

    void setLogoutTokenDecoderFactory(ReactiveJwtDecoderFactory<ClientRegistration> logoutTokenDecoderFactory) {
        Assert.notNull(logoutTokenDecoderFactory, (String)"logoutTokenDecoderFactory cannot be null");
        this.logoutTokenDecoderFactory = logoutTokenDecoderFactory;
    }
}

