/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configurers.ldap;

import java.io.IOException;
import java.net.ServerSocket;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.ProviderManagerBuilder;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleAuthorityMapper;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.authentication.PasswordComparisonAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.server.ApacheDSContainer;
import org.springframework.security.ldap.server.UnboundIdContainer;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class LdapAuthenticationProviderConfigurer<B extends ProviderManagerBuilder<B>>
extends SecurityConfigurerAdapter<AuthenticationManager, B> {
    private String groupRoleAttribute = "cn";
    private String groupSearchBase = "";
    private boolean groupSearchSubtree = false;
    private String groupSearchFilter = "(uniqueMember={0})";
    private String rolePrefix = "ROLE_";
    private String userSearchBase = "";
    private String userSearchFilter = null;
    private String[] userDnPatterns;
    private BaseLdapPathContextSource contextSource;
    private ContextSourceBuilder contextSourceBuilder = new ContextSourceBuilder();
    private UserDetailsContextMapper userDetailsContextMapper;
    private PasswordEncoder passwordEncoder;
    private String passwordAttribute;
    private LdapAuthoritiesPopulator ldapAuthoritiesPopulator;
    private GrantedAuthoritiesMapper authoritiesMapper;

    private LdapAuthenticationProvider build() throws Exception {
        BaseLdapPathContextSource contextSource = this.getContextSource();
        LdapAuthenticator ldapAuthenticator = this.createLdapAuthenticator(contextSource);
        LdapAuthoritiesPopulator authoritiesPopulator = this.getLdapAuthoritiesPopulator();
        LdapAuthenticationProvider ldapAuthenticationProvider = new LdapAuthenticationProvider(ldapAuthenticator, authoritiesPopulator);
        ldapAuthenticationProvider.setAuthoritiesMapper(this.getAuthoritiesMapper());
        if (this.userDetailsContextMapper != null) {
            ldapAuthenticationProvider.setUserDetailsContextMapper(this.userDetailsContextMapper);
        }
        return ldapAuthenticationProvider;
    }

    public LdapAuthenticationProviderConfigurer<B> ldapAuthoritiesPopulator(LdapAuthoritiesPopulator ldapAuthoritiesPopulator) {
        this.ldapAuthoritiesPopulator = ldapAuthoritiesPopulator;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.addObjectPostProcessor(objectPostProcessor);
        return this;
    }

    private LdapAuthoritiesPopulator getLdapAuthoritiesPopulator() {
        if (this.ldapAuthoritiesPopulator != null) {
            return this.ldapAuthoritiesPopulator;
        }
        DefaultLdapAuthoritiesPopulator defaultAuthoritiesPopulator = new DefaultLdapAuthoritiesPopulator((ContextSource)this.contextSource, this.groupSearchBase);
        defaultAuthoritiesPopulator.setGroupRoleAttribute(this.groupRoleAttribute);
        defaultAuthoritiesPopulator.setGroupSearchFilter(this.groupSearchFilter);
        defaultAuthoritiesPopulator.setSearchSubtree(this.groupSearchSubtree);
        defaultAuthoritiesPopulator.setRolePrefix(this.rolePrefix);
        this.ldapAuthoritiesPopulator = defaultAuthoritiesPopulator;
        return defaultAuthoritiesPopulator;
    }

    public LdapAuthenticationProviderConfigurer<B> authoritiesMapper(GrantedAuthoritiesMapper grantedAuthoritiesMapper) {
        this.authoritiesMapper = grantedAuthoritiesMapper;
        return this;
    }

    protected GrantedAuthoritiesMapper getAuthoritiesMapper() throws Exception {
        if (this.authoritiesMapper != null) {
            return this.authoritiesMapper;
        }
        SimpleAuthorityMapper simpleAuthorityMapper = new SimpleAuthorityMapper();
        simpleAuthorityMapper.setPrefix(this.rolePrefix);
        simpleAuthorityMapper.afterPropertiesSet();
        this.authoritiesMapper = simpleAuthorityMapper;
        return simpleAuthorityMapper;
    }

    private LdapAuthenticator createLdapAuthenticator(BaseLdapPathContextSource contextSource) {
        PasswordComparisonAuthenticator ldapAuthenticator = this.passwordEncoder != null ? this.createPasswordCompareAuthenticator(contextSource) : this.createBindAuthenticator(contextSource);
        LdapUserSearch userSearch = this.createUserSearch();
        if (userSearch != null) {
            ldapAuthenticator.setUserSearch(userSearch);
        }
        if (this.userDnPatterns != null && this.userDnPatterns.length > 0) {
            ldapAuthenticator.setUserDnPatterns(this.userDnPatterns);
        }
        return (LdapAuthenticator)this.postProcess(ldapAuthenticator);
    }

    private PasswordComparisonAuthenticator createPasswordCompareAuthenticator(BaseLdapPathContextSource contextSource) {
        PasswordComparisonAuthenticator ldapAuthenticator = new PasswordComparisonAuthenticator(contextSource);
        if (this.passwordAttribute != null) {
            ldapAuthenticator.setPasswordAttributeName(this.passwordAttribute);
        }
        ldapAuthenticator.setPasswordEncoder(this.passwordEncoder);
        return ldapAuthenticator;
    }

    private BindAuthenticator createBindAuthenticator(BaseLdapPathContextSource contextSource) {
        return new BindAuthenticator(contextSource);
    }

    private LdapUserSearch createUserSearch() {
        if (this.userSearchFilter == null) {
            return null;
        }
        return new FilterBasedLdapUserSearch(this.userSearchBase, this.userSearchFilter, this.contextSource);
    }

    public LdapAuthenticationProviderConfigurer<B> contextSource(BaseLdapPathContextSource contextSource) {
        this.contextSource = contextSource;
        return this;
    }

    public ContextSourceBuilder contextSource() {
        return this.contextSourceBuilder;
    }

    public LdapAuthenticationProviderConfigurer<B> passwordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder must not be null.");
        this.passwordEncoder = passwordEncoder;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> userDnPatterns(String ... userDnPatterns) {
        this.userDnPatterns = userDnPatterns;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> userDetailsContextMapper(UserDetailsContextMapper userDetailsContextMapper) {
        this.userDetailsContextMapper = userDetailsContextMapper;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> groupRoleAttribute(String groupRoleAttribute) {
        this.groupRoleAttribute = groupRoleAttribute;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> groupSearchBase(String groupSearchBase) {
        this.groupSearchBase = groupSearchBase;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> groupSearchSubtree(boolean groupSearchSubtree) {
        this.groupSearchSubtree = groupSearchSubtree;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> groupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> rolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> userSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> userSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
        return this;
    }

    @Override
    public void configure(B builder) throws Exception {
        LdapAuthenticationProvider provider = this.postProcess(this.build());
        builder.authenticationProvider((AuthenticationProvider)provider);
    }

    private BaseLdapPathContextSource getContextSource() throws Exception {
        if (this.contextSource == null) {
            this.contextSource = this.contextSourceBuilder.build();
        }
        return this.contextSource;
    }

    public PasswordCompareConfigurer passwordCompare() {
        return new PasswordCompareConfigurer().passwordAttribute("password").passwordEncoder(NoOpPasswordEncoder.getInstance());
    }

    public final class ContextSourceBuilder {
        private static final String APACHEDS_CLASSNAME = "org.apache.directory.server.core.DefaultDirectoryService";
        private static final String UNBOUNDID_CLASSNAME = "com.unboundid.ldap.listener.InMemoryDirectoryServer";
        private static final int DEFAULT_PORT = 33389;
        private static final int RANDOM_PORT = 0;
        private String ldif = "classpath*:*.ldif";
        private String managerPassword;
        private String managerDn;
        private Integer port;
        private String root = "dc=springframework,dc=org";
        private String url;

        public ContextSourceBuilder ldif(String ldif) {
            this.ldif = ldif;
            return this;
        }

        public ContextSourceBuilder managerDn(String managerDn) {
            this.managerDn = managerDn;
            return this;
        }

        public ContextSourceBuilder managerPassword(String managerPassword) {
            this.managerPassword = managerPassword;
            return this;
        }

        public ContextSourceBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ContextSourceBuilder root(String root) {
            this.root = root;
            return this;
        }

        public ContextSourceBuilder url(String url) {
            this.url = url;
            return this;
        }

        public LdapAuthenticationProviderConfigurer<B> and() {
            return LdapAuthenticationProviderConfigurer.this;
        }

        private DefaultSpringSecurityContextSource build() throws Exception {
            if (this.url == null) {
                this.startEmbeddedLdapServer();
            }
            DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(this.getProviderUrl());
            if (this.managerDn != null) {
                contextSource.setUserDn(this.managerDn);
                if (this.managerPassword == null) {
                    throw new IllegalStateException("managerPassword is required if managerDn is supplied");
                }
                contextSource.setPassword(this.managerPassword);
            }
            contextSource = (DefaultSpringSecurityContextSource)LdapAuthenticationProviderConfigurer.this.postProcess(contextSource);
            return contextSource;
        }

        private void startEmbeddedLdapServer() throws Exception {
            if (ClassUtils.isPresent((String)APACHEDS_CLASSNAME, (ClassLoader)this.getClass().getClassLoader())) {
                ApacheDSContainer apacheDsContainer = new ApacheDSContainer(this.root, this.ldif);
                apacheDsContainer.setPort(this.getPort());
                LdapAuthenticationProviderConfigurer.this.postProcess(apacheDsContainer);
                this.port = apacheDsContainer.getLocalPort();
            } else if (ClassUtils.isPresent((String)UNBOUNDID_CLASSNAME, (ClassLoader)this.getClass().getClassLoader())) {
                UnboundIdContainer unboundIdContainer = new UnboundIdContainer(this.root, this.ldif);
                unboundIdContainer.setPort(this.getPort());
                LdapAuthenticationProviderConfigurer.this.postProcess(unboundIdContainer);
                this.port = unboundIdContainer.getPort();
            } else {
                throw new IllegalStateException("Embedded LDAP server is not provided");
            }
        }

        private int getPort() {
            if (this.port == null) {
                this.port = this.getDefaultPort();
            }
            return this.port;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int getDefaultPort() {
            try (ServerSocket serverSocket = new ServerSocket(33389);){
                int n = serverSocket.getLocalPort();
                return n;
            }
            catch (IOException ex) {
                return 0;
            }
        }

        private String getProviderUrl() {
            if (this.url == null) {
                return "ldap://127.0.0.1:" + this.getPort() + "/" + this.root;
            }
            return this.url;
        }

        private ContextSourceBuilder() {
        }
    }

    public final class PasswordCompareConfigurer {
        public PasswordCompareConfigurer passwordEncoder(PasswordEncoder passwordEncoder) {
            LdapAuthenticationProviderConfigurer.this.passwordEncoder = passwordEncoder;
            return this;
        }

        public PasswordCompareConfigurer passwordAttribute(String passwordAttribute) {
            LdapAuthenticationProviderConfigurer.this.passwordAttribute = passwordAttribute;
            return this;
        }

        public LdapAuthenticationProviderConfigurer<B> and() {
            return LdapAuthenticationProviderConfigurer.this;
        }

        private PasswordCompareConfigurer() {
        }
    }
}

