/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.method.annotation.OAuth2AuthorizedClientArgumentResolver;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Import(value={OAuth2ClientWebMvcImportSelector.class})
final class OAuth2ClientConfiguration {
    OAuth2ClientConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    static class OAuth2ClientWebMvcSecurityConfiguration
    implements WebMvcConfigurer {
        private ClientRegistrationRepository clientRegistrationRepository;
        private OAuth2AuthorizedClientRepository authorizedClientRepository;
        private OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> accessTokenResponseClient;
        private OAuth2AuthorizedClientManager authorizedClientManager;
        private SecurityContextHolderStrategy securityContextHolderStrategy;

        OAuth2ClientWebMvcSecurityConfiguration() {
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            OAuth2AuthorizedClientManager authorizedClientManager = this.getAuthorizedClientManager();
            if (authorizedClientManager != null) {
                OAuth2AuthorizedClientArgumentResolver resolver = new OAuth2AuthorizedClientArgumentResolver(authorizedClientManager);
                if (this.securityContextHolderStrategy != null) {
                    resolver.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
                }
                argumentResolvers.add((HandlerMethodArgumentResolver)resolver);
            }
        }

        @Autowired(required=false)
        void setClientRegistrationRepository(List<ClientRegistrationRepository> clientRegistrationRepositories) {
            if (clientRegistrationRepositories.size() == 1) {
                this.clientRegistrationRepository = clientRegistrationRepositories.get(0);
            }
        }

        @Autowired(required=false)
        void setAuthorizedClientRepository(List<OAuth2AuthorizedClientRepository> authorizedClientRepositories) {
            if (authorizedClientRepositories.size() == 1) {
                this.authorizedClientRepository = authorizedClientRepositories.get(0);
            }
        }

        @Autowired(required=false)
        void setAccessTokenResponseClient(OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> accessTokenResponseClient) {
            this.accessTokenResponseClient = accessTokenResponseClient;
        }

        @Autowired(required=false)
        void setAuthorizedClientManager(List<OAuth2AuthorizedClientManager> authorizedClientManagers) {
            if (authorizedClientManagers.size() == 1) {
                this.authorizedClientManager = authorizedClientManagers.get(0);
            }
        }

        @Autowired(required=false)
        void setSecurityContextHolderStrategy(SecurityContextHolderStrategy strategy) {
            this.securityContextHolderStrategy = strategy;
        }

        private OAuth2AuthorizedClientManager getAuthorizedClientManager() {
            if (this.authorizedClientManager != null) {
                return this.authorizedClientManager;
            }
            DefaultOAuth2AuthorizedClientManager authorizedClientManager = null;
            if (this.clientRegistrationRepository != null && this.authorizedClientRepository != null) {
                if (this.accessTokenResponseClient != null) {
                    OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().clientCredentials(configurer -> configurer.accessTokenResponseClient(this.accessTokenResponseClient)).password().build();
                    DefaultOAuth2AuthorizedClientManager defaultAuthorizedClientManager = new DefaultOAuth2AuthorizedClientManager(this.clientRegistrationRepository, this.authorizedClientRepository);
                    defaultAuthorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
                    authorizedClientManager = defaultAuthorizedClientManager;
                } else {
                    authorizedClientManager = new DefaultOAuth2AuthorizedClientManager(this.clientRegistrationRepository, this.authorizedClientRepository);
                }
            }
            return authorizedClientManager;
        }
    }

    static class OAuth2ClientWebMvcImportSelector
    implements ImportSelector {
        OAuth2ClientWebMvcImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            if (!ClassUtils.isPresent((String)"org.springframework.web.servlet.DispatcherServlet", (ClassLoader)this.getClass().getClassLoader())) {
                return new String[0];
            }
            return new String[]{"org.springframework.security.config.annotation.web.configuration.OAuth2ClientConfiguration.OAuth2ClientWebMvcSecurityConfiguration"};
        }
    }
}

