/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.util.Arrays;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.ExpressionBasedAnnotationAttributeFactory;
import org.springframework.security.access.expression.method.ExpressionBasedPostInvocationAdvice;
import org.springframework.security.access.expression.method.ExpressionBasedPreInvocationAdvice;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityMetadataSourceAdvisor;
import org.springframework.security.access.method.AbstractMethodSecurityMetadataSource;
import org.springframework.security.access.method.DelegatingMethodSecurityMetadataSource;
import org.springframework.security.access.method.MethodSecurityMetadataSource;
import org.springframework.security.access.prepost.PostInvocationAuthorizationAdvice;
import org.springframework.security.access.prepost.PreInvocationAuthorizationAdvice;
import org.springframework.security.access.prepost.PrePostAdviceReactiveMethodInterceptor;
import org.springframework.security.access.prepost.PrePostAnnotationSecurityMetadataSource;
import org.springframework.security.access.prepost.PrePostInvocationAttributeFactory;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;

@Configuration
class ReactiveMethodSecurityConfiguration
implements ImportAware {
    private int advisorOrder;

    ReactiveMethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    public MethodSecurityMetadataSourceAdvisor methodSecurityInterceptor(AbstractMethodSecurityMetadataSource source) throws Exception {
        MethodSecurityMetadataSourceAdvisor advisor = new MethodSecurityMetadataSourceAdvisor("securityMethodInterceptor", (MethodSecurityMetadataSource)source, "methodMetadataSource");
        advisor.setOrder(this.advisorOrder);
        return advisor;
    }

    @Bean
    @Role(value=2)
    public DelegatingMethodSecurityMetadataSource methodMetadataSource() {
        ExpressionBasedAnnotationAttributeFactory attributeFactory = new ExpressionBasedAnnotationAttributeFactory((MethodSecurityExpressionHandler)new DefaultMethodSecurityExpressionHandler());
        PrePostAnnotationSecurityMetadataSource prePostSource = new PrePostAnnotationSecurityMetadataSource((PrePostInvocationAttributeFactory)attributeFactory);
        return new DelegatingMethodSecurityMetadataSource(Arrays.asList(prePostSource));
    }

    @Bean
    public PrePostAdviceReactiveMethodInterceptor securityMethodInterceptor(AbstractMethodSecurityMetadataSource source, MethodSecurityExpressionHandler handler) {
        ExpressionBasedPostInvocationAdvice postAdvice = new ExpressionBasedPostInvocationAdvice(handler);
        ExpressionBasedPreInvocationAdvice preAdvice = new ExpressionBasedPreInvocationAdvice();
        preAdvice.setExpressionHandler(handler);
        return new PrePostAdviceReactiveMethodInterceptor((MethodSecurityMetadataSource)source, (PreInvocationAuthorizationAdvice)preAdvice, (PostInvocationAuthorizationAdvice)postAdvice);
    }

    @Bean
    @Role(value=2)
    public DefaultMethodSecurityExpressionHandler methodSecurityExpressionHandler() {
        return new DefaultMethodSecurityExpressionHandler();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.advisorOrder = (Integer)importMetadata.getAnnotationAttributes(EnableReactiveMethodSecurity.class.getName()).get("order");
    }
}

