/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.io.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.geode.core.io.AbstractResourceReader;
import org.springframework.lang.NonNull;

public class ByteArrayResourceReader
extends AbstractResourceReader {
    protected static final int DEFAULT_BUFFER_SIZE = 32768;

    protected int getBufferSize() {
        return 32768;
    }

    @Override
    @NonNull
    protected byte[] doRead(@NonNull InputStream resourceInputStream) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(resourceInputStream.available());){
            byte[] buffer = new byte[this.getBufferSize()];
            int bytesRead = resourceInputStream.read(buffer);
            while (bytesRead != -1) {
                out.write(buffer, 0, bytesRead);
                bytesRead = resourceInputStream.read(buffer);
            }
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

