/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.cache;

import java.util.function.Supplier;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.RegionEvent;
import org.springframework.data.repository.CrudRepository;
import org.springframework.geode.cache.support.RepositoryCacheLoaderWriterSupport;
import org.springframework.geode.core.util.function.FunctionUtils;

public class RepositoryCacheWriter<T, ID>
extends RepositoryCacheLoaderWriterSupport<T, ID> {
    public RepositoryCacheWriter(CrudRepository<T, ID> repository) {
        super(repository);
    }

    @Override
    public void beforeCreate(EntryEvent<ID, T> event) throws CacheWriterException {
        this.doRepositoryOp(event.getNewValue(), arg_0 -> this.getRepository().save(arg_0));
    }

    @Override
    public void beforeUpdate(EntryEvent<ID, T> event) throws CacheWriterException {
        this.doRepositoryOp(event.getNewValue(), arg_0 -> this.getRepository().save(arg_0));
    }

    @Override
    public void beforeDestroy(EntryEvent<ID, T> event) throws CacheWriterException {
        this.doRepositoryOp(event.getKey(), FunctionUtils.toNullReturningFunction(arg_0 -> this.getRepository().deleteById(arg_0)));
    }

    @Override
    public void beforeRegionClear(RegionEvent<ID, T> event) throws CacheWriterException {
        if (this.isNukeAndPaveEnabled()) {
            this.doRepositoryOp(null, FunctionUtils.toNullReturningFunction(it -> this.getRepository().deleteAll()));
        }
    }

    @Override
    public void beforeRegionDestroy(RegionEvent<ID, T> event) throws CacheWriterException {
    }

    @Override
    protected CacheRuntimeException newCacheRuntimeException(Supplier<String> messageSupplier, Throwable cause) {
        return new CacheWriterException(messageSupplier.get(), cause);
    }
}

