/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.data.jpa.repository.query.EqlBaseVisitor;
import org.springframework.data.jpa.repository.query.EqlParser;
import org.springframework.data.jpa.repository.query.EqlQueryRenderer;
import org.springframework.data.jpa.repository.query.ParsedQueryIntrospector;
import org.springframework.data.jpa.repository.query.QueryInformation;
import org.springframework.data.jpa.repository.query.QueryInformationHolder;

class EqlQueryIntrospector
extends EqlBaseVisitor<Void>
implements ParsedQueryIntrospector<QueryInformation> {
    private final EqlQueryRenderer renderer = new EqlQueryRenderer();
    private final QueryInformationHolder introspection = new QueryInformationHolder();

    EqlQueryIntrospector() {
    }

    @Override
    public QueryInformation getParsedQueryInformation() {
        return new QueryInformation(this.introspection);
    }

    @Override
    public Void visitSelectQuery(EqlParser.SelectQueryContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.SELECT);
        return (Void)super.visitSelectQuery(ctx);
    }

    @Override
    public Void visitFromQuery(EqlParser.FromQueryContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.SELECT);
        return (Void)super.visitFromQuery(ctx);
    }

    @Override
    public Void visitUpdate_statement(EqlParser.Update_statementContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.UPDATE);
        return (Void)super.visitUpdate_statement(ctx);
    }

    @Override
    public Void visitDelete_statement(EqlParser.Delete_statementContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.DELETE);
        return (Void)super.visitDelete_statement(ctx);
    }

    @Override
    public Void visitSelect_clause(EqlParser.Select_clauseContext ctx) {
        this.introspection.captureProjection(ctx.select_item(), this.renderer::visitSelect_item);
        return (Void)super.visitSelect_clause(ctx);
    }

    @Override
    public Void visitRange_variable_declaration(EqlParser.Range_variable_declarationContext ctx) {
        if (ctx.identification_variable() != null && !EqlQueryRenderer.isSubquery(ctx) && !EqlQueryRenderer.isSetQuery(ctx)) {
            this.introspection.capturePrimaryAlias(ctx.identification_variable().getText());
        }
        return (Void)super.visitRange_variable_declaration(ctx);
    }

    @Override
    public Void visitConstructor_expression(EqlParser.Constructor_expressionContext ctx) {
        this.introspection.constructorExpressionPresent();
        return (Void)super.visitConstructor_expression(ctx);
    }
}

