/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.NamedStoredProcedureQueries;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.StoredProcedureParameter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.jpa.repository.query.ProcedureParameter;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributes;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

enum StoredProcedureAttributeSource {
    INSTANCE;


    public StoredProcedureAttributes createFrom(Method method, JpaEntityMetadata<?> entityMetadata) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        Assert.notNull(entityMetadata, (String)"EntityMetadata must not be null");
        Procedure procedure = (Procedure)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Procedure.class);
        Assert.notNull((Object)procedure, (String)"Method must have an @Procedure annotation");
        NamedStoredProcedureQuery namedStoredProc = this.tryFindAnnotatedNamedStoredProcedureQuery(method, entityMetadata, procedure);
        if (namedStoredProc != null) {
            return this.newProcedureAttributesFrom(method, namedStoredProc, procedure);
        }
        String procedureName = this.deriveProcedureNameFrom(method, procedure);
        if (ObjectUtils.isEmpty((Object)procedureName)) {
            throw new IllegalArgumentException("Could not determine name of procedure for @Procedure annotated method: " + String.valueOf(method));
        }
        return new StoredProcedureAttributes(procedureName, this.createOutputProcedureParameterFrom(method, procedure));
    }

    private String deriveProcedureNameFrom(Method method, Procedure procedure) {
        if (StringUtils.hasText((String)procedure.value())) {
            return procedure.value();
        }
        String procedureName = procedure.procedureName();
        return StringUtils.hasText((String)procedureName) ? procedureName : method.getName();
    }

    private StoredProcedureAttributes newProcedureAttributesFrom(Method method, NamedStoredProcedureQuery namedStoredProc, Procedure procedure) {
        List<ProcedureParameter> outputParameters = !procedure.outputParameterName().isEmpty() ? Collections.singletonList(this.createOutputProcedureParameterFrom(method, procedure)) : this.extractOutputParametersFrom(namedStoredProc);
        return new StoredProcedureAttributes(namedStoredProc.name(), outputParameters, true);
    }

    private ProcedureParameter createOutputProcedureParameterFrom(Method method, Procedure procedure) {
        return new ProcedureParameter(procedure.outputParameterName(), 1, procedure.refCursor() ? ParameterMode.REF_CURSOR : ParameterMode.OUT, method.getReturnType());
    }

    private List<ProcedureParameter> extractOutputParametersFrom(NamedStoredProcedureQuery namedStoredProc) {
        ArrayList<ProcedureParameter> outputParameters = new ArrayList<ProcedureParameter>();
        int position = 1;
        StoredProcedureParameter[] storedProcedureParameterArray = namedStoredProc.parameters();
        int n = storedProcedureParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            StoredProcedureParameter param = storedProcedureParameterArray[n2];
            switch (param.mode()) {
                case INOUT: 
                case OUT: 
                case REF_CURSOR: {
                    outputParameters.add(new ProcedureParameter(param.name(), position, param.mode(), param.type()));
                }
            }
            ++position;
            ++n2;
        }
        return outputParameters;
    }

    @Nullable
    private NamedStoredProcedureQuery tryFindAnnotatedNamedStoredProcedureQuery(Method method, JpaEntityMetadata<?> entityMetadata, Procedure procedure) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        Assert.notNull(entityMetadata, (String)"EntityMetadata must not be null");
        Assert.notNull((Object)procedure, (String)"Procedure must not be null");
        Class entityType = entityMetadata.getJavaType();
        List<NamedStoredProcedureQuery> queries = this.collectNamedStoredProcedureQueriesFrom(entityType);
        if (queries.isEmpty()) {
            return null;
        }
        String namedProcedureName = this.derivedNamedProcedureNameFrom(method, entityMetadata, procedure);
        for (NamedStoredProcedureQuery query : queries) {
            if (!query.name().equals(namedProcedureName)) continue;
            return query;
        }
        return null;
    }

    private String derivedNamedProcedureNameFrom(Method method, JpaEntityMetadata<?> entityMetadata, Procedure procedure) {
        return StringUtils.hasText((String)procedure.name()) ? procedure.name() : entityMetadata.getEntityName() + "." + method.getName();
    }

    private List<NamedStoredProcedureQuery> collectNamedStoredProcedureQueriesFrom(Class<?> entityType) {
        NamedStoredProcedureQuery namedQueryAnnotation;
        ArrayList<NamedStoredProcedureQuery> queries = new ArrayList<NamedStoredProcedureQuery>();
        NamedStoredProcedureQueries namedQueriesAnnotation = (NamedStoredProcedureQueries)AnnotatedElementUtils.findMergedAnnotation(entityType, NamedStoredProcedureQueries.class);
        if (namedQueriesAnnotation != null) {
            queries.addAll(Arrays.asList(namedQueriesAnnotation.value()));
        }
        if ((namedQueryAnnotation = (NamedStoredProcedureQuery)AnnotatedElementUtils.findMergedAnnotation(entityType, NamedStoredProcedureQuery.class)) != null) {
            queries.add(namedQueryAnnotation);
        }
        return queries;
    }
}

