/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.convert.QueryByExamplePredicateBuilder;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.DefaultQueryHints;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.JpaRepositoryImplementation;
import org.springframework.data.jpa.repository.support.QueryHints;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.data.util.ProxyUtils;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Repository
@Transactional(readOnly=true)
public class SimpleJpaRepository<T, ID>
implements JpaRepositoryImplementation<T, ID> {
    private static final String ID_MUST_NOT_BE_NULL = "The given id must not be null!";
    private final JpaEntityInformation<T, ?> entityInformation;
    private final EntityManager em;
    private final PersistenceProvider provider;
    @Nullable
    private CrudMethodMetadata metadata;
    private EscapeCharacter escapeCharacter = EscapeCharacter.DEFAULT;

    private static <T> Collection<T> toCollection(Iterable<T> ts) {
        if (ts instanceof Collection) {
            return (Collection)ts;
        }
        ArrayList<T> tCollection = new ArrayList<T>();
        for (T t : ts) {
            tCollection.add(t);
        }
        return tCollection;
    }

    public SimpleJpaRepository(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        Assert.notNull(entityInformation, (String)"JpaEntityInformation must not be null!");
        Assert.notNull((Object)entityManager, (String)"EntityManager must not be null!");
        this.entityInformation = entityInformation;
        this.em = entityManager;
        this.provider = PersistenceProvider.fromEntityManager(entityManager);
    }

    public SimpleJpaRepository(Class<T> domainClass, EntityManager em) {
        this(JpaEntityInformationSupport.getEntityInformation(domainClass, em), em);
    }

    @Override
    public void setRepositoryMethodMetadata(CrudMethodMetadata crudMethodMetadata) {
        this.metadata = crudMethodMetadata;
    }

    @Override
    public void setEscapeCharacter(EscapeCharacter escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    @Nullable
    protected CrudMethodMetadata getRepositoryMethodMetadata() {
        return this.metadata;
    }

    protected Class<T> getDomainClass() {
        return this.entityInformation.getJavaType();
    }

    private String getDeleteAllQueryString() {
        return QueryUtils.getQueryString("delete from %s x", this.entityInformation.getEntityName());
    }

    private String getCountQueryString() {
        String countQuery = String.format("select count(%s) from %s x", this.provider.getCountQueryPlaceholder(), "%s");
        return QueryUtils.getQueryString(countQuery, this.entityInformation.getEntityName());
    }

    @Transactional
    public void deleteById(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        this.delete(this.findById(id).orElseThrow(() -> new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.entityInformation.getJavaType(), id), 1)));
    }

    @Transactional
    public void delete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            return;
        }
        Class type = ProxyUtils.getUserClass(entity);
        Object existing = this.em.find(type, this.entityInformation.getId(entity));
        if (existing == null) {
            return;
        }
        this.em.remove(this.em.contains(entity) ? entity : this.em.merge(entity));
    }

    @Transactional
    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Entities must not be null!");
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    @Transactional
    public void deleteInBatch(Iterable<T> entities) {
        Assert.notNull(entities, (String)"Entities must not be null!");
        if (!entities.iterator().hasNext()) {
            return;
        }
        QueryUtils.applyAndBind(QueryUtils.getQueryString("delete from %s x", this.entityInformation.getEntityName()), entities, this.em).executeUpdate();
    }

    @Transactional
    public void deleteAll() {
        for (Object element : this.findAll()) {
            this.delete(element);
        }
    }

    @Override
    @Transactional
    public void deleteAllInBatch() {
        this.em.createQuery(this.getDeleteAllQueryString()).executeUpdate();
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        Class<T> domainType = this.getDomainClass();
        if (this.metadata == null) {
            return Optional.ofNullable(this.em.find(domainType, id));
        }
        LockModeType type = this.metadata.getLockModeType();
        Map<String, Object> hints = this.getQueryHints().withFetchGraphs(this.em).asMap();
        return Optional.ofNullable(type == null ? this.em.find(domainType, id, hints) : this.em.find(domainType, id, type, hints));
    }

    protected QueryHints getQueryHints() {
        return this.metadata == null ? QueryHints.NoHints.INSTANCE : DefaultQueryHints.of(this.entityInformation, this.metadata);
    }

    @Override
    public T getOne(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        return (T)this.em.getReference(this.getDomainClass(), id);
    }

    public boolean existsById(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        if (this.entityInformation.getIdAttribute() == null) {
            return this.findById(id).isPresent();
        }
        String placeholder = this.provider.getCountQueryPlaceholder();
        String entityName = this.entityInformation.getEntityName();
        Iterable<String> idAttributeNames = this.entityInformation.getIdAttributeNames();
        String existsQuery = QueryUtils.getExistsQueryString(entityName, placeholder, idAttributeNames);
        TypedQuery query = this.em.createQuery(existsQuery, Long.class);
        if (!this.entityInformation.hasCompositeId()) {
            query.setParameter(idAttributeNames.iterator().next(), id);
            return (Long)query.getSingleResult() == 1L;
        }
        for (String idAttributeName : idAttributeNames) {
            boolean complexIdParameterValueDiscovered;
            Object idAttributeValue = this.entityInformation.getCompositeIdAttributeValue(id, idAttributeName);
            boolean bl = complexIdParameterValueDiscovered = idAttributeValue != null && !query.getParameter(idAttributeName).getParameterType().isAssignableFrom(idAttributeValue.getClass());
            if (complexIdParameterValueDiscovered) {
                return this.findById(id).isPresent();
            }
            query.setParameter(idAttributeName, idAttributeValue);
        }
        return (Long)query.getSingleResult() == 1L;
    }

    @Override
    public List<T> findAll() {
        return this.getQuery(null, Sort.unsorted()).getResultList();
    }

    @Override
    public List<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        if (!ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        if (this.entityInformation.hasCompositeId()) {
            ArrayList results = new ArrayList();
            for (ID id : ids) {
                this.findById(id).ifPresent(results::add);
            }
            return results;
        }
        Collection<ID> idCollection = SimpleJpaRepository.toCollection(ids);
        ByIdsSpecification<T> specification = new ByIdsSpecification<T>(this.entityInformation);
        TypedQuery<T> query = this.getQuery(specification, Sort.unsorted());
        return query.setParameter(specification.parameter, idCollection).getResultList();
    }

    @Override
    public List<T> findAll(Sort sort) {
        return this.getQuery(null, sort).getResultList();
    }

    public Page<T> findAll(Pageable pageable) {
        if (SimpleJpaRepository.isUnpaged(pageable)) {
            return new PageImpl((List)this.findAll());
        }
        return this.findAll((Specification)null, pageable);
    }

    @Override
    public Optional<T> findOne(@Nullable Specification<T> spec) {
        try {
            return Optional.of(this.getQuery(spec, Sort.unsorted()).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    @Override
    public List<T> findAll(@Nullable Specification<T> spec) {
        return this.getQuery(spec, Sort.unsorted()).getResultList();
    }

    @Override
    public Page<T> findAll(@Nullable Specification<T> spec, Pageable pageable) {
        TypedQuery<T> query = this.getQuery(spec, pageable);
        return SimpleJpaRepository.isUnpaged(pageable) ? new Page<T>(query.getResultList()) : this.readPage(query, this.getDomainClass(), pageable, spec);
    }

    @Override
    public List<T> findAll(@Nullable Specification<T> spec, Sort sort) {
        return this.getQuery(spec, sort).getResultList();
    }

    @Override
    public <S extends T> Optional<S> findOne(Example<S> example) {
        try {
            return Optional.of(this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType(), Sort.unsorted()).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    @Override
    public <S extends T> long count(Example<S> example) {
        return SimpleJpaRepository.executeCountQuery(this.getCountQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType()));
    }

    public <S extends T> boolean exists(Example<S> example) {
        return !this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType(), Sort.unsorted()).getResultList().isEmpty();
    }

    @Override
    public <S extends T> List<S> findAll(Example<S> example) {
        return this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType(), Sort.unsorted()).getResultList();
    }

    @Override
    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        return this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType(), sort).getResultList();
    }

    @Override
    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        ExampleSpecification<S> spec = new ExampleSpecification<S>(example, this.escapeCharacter);
        Class probeType = example.getProbeType();
        TypedQuery<S> query = this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), probeType, pageable);
        return SimpleJpaRepository.isUnpaged(pageable) ? new Page<S>(query.getResultList()) : this.readPage(query, probeType, pageable, spec);
    }

    public long count() {
        return (Long)this.em.createQuery(this.getCountQueryString(), Long.class).getSingleResult();
    }

    @Override
    public long count(@Nullable Specification<T> spec) {
        return SimpleJpaRepository.executeCountQuery(this.getCountQuery(spec, this.getDomainClass()));
    }

    @Transactional
    public <S extends T> S save(S entity) {
        if (this.entityInformation.isNew(entity)) {
            this.em.persist(entity);
            return entity;
        }
        return (S)this.em.merge(entity);
    }

    @Override
    @Transactional
    public <S extends T> S saveAndFlush(S entity) {
        S result = this.save(entity);
        this.flush();
        return result;
    }

    @Override
    @Transactional
    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Entities must not be null!");
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    @Override
    @Transactional
    public void flush() {
        this.em.flush();
    }

    @Deprecated
    protected Page<T> readPage(TypedQuery<T> query, Pageable pageable, @Nullable Specification<T> spec) {
        return this.readPage(query, this.getDomainClass(), pageable, spec);
    }

    protected <S extends T> Page<S> readPage(TypedQuery<S> query, Class<S> domainClass, Pageable pageable, @Nullable Specification<S> spec) {
        if (pageable.isPaged()) {
            query.setFirstResult((int)pageable.getOffset());
            query.setMaxResults(pageable.getPageSize());
        }
        return PageableExecutionUtils.getPage((List)query.getResultList(), (Pageable)pageable, () -> SimpleJpaRepository.executeCountQuery(this.getCountQuery(spec, domainClass)));
    }

    protected TypedQuery<T> getQuery(@Nullable Specification<T> spec, Pageable pageable) {
        Sort sort = pageable.isPaged() ? pageable.getSort() : Sort.unsorted();
        return this.getQuery(spec, this.getDomainClass(), sort);
    }

    protected <S extends T> TypedQuery<S> getQuery(@Nullable Specification<S> spec, Class<S> domainClass, Pageable pageable) {
        Sort sort = pageable.isPaged() ? pageable.getSort() : Sort.unsorted();
        return this.getQuery(spec, domainClass, sort);
    }

    protected TypedQuery<T> getQuery(@Nullable Specification<T> spec, Sort sort) {
        return this.getQuery(spec, this.getDomainClass(), sort);
    }

    protected <S extends T> TypedQuery<S> getQuery(@Nullable Specification<S> spec, Class<S> domainClass, Sort sort) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(domainClass);
        Root<S> root = this.applySpecificationToCriteria(spec, domainClass, query);
        query.select(root);
        if (sort.isSorted()) {
            query.orderBy(QueryUtils.toOrders(sort, root, builder));
        }
        return this.applyRepositoryMethodMetadata(this.em.createQuery(query));
    }

    @Deprecated
    protected TypedQuery<Long> getCountQuery(@Nullable Specification<T> spec) {
        return this.getCountQuery(spec, this.getDomainClass());
    }

    protected <S extends T> TypedQuery<Long> getCountQuery(@Nullable Specification<S> spec, Class<S> domainClass) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root<S> root = this.applySpecificationToCriteria(spec, domainClass, query);
        if (query.isDistinct()) {
            query.select((Selection)builder.countDistinct(root));
        } else {
            query.select((Selection)builder.count(root));
        }
        query.orderBy(Collections.emptyList());
        return this.em.createQuery(query);
    }

    private <S, U extends T> Root<U> applySpecificationToCriteria(@Nullable Specification<U> spec, Class<U> domainClass, CriteriaQuery<S> query) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        Assert.notNull(query, (String)"CriteriaQuery must not be null!");
        Root root = query.from(domainClass);
        if (spec == null) {
            return root;
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        Predicate predicate = spec.toPredicate(root, query, builder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        return root;
    }

    private <S> TypedQuery<S> applyRepositoryMethodMetadata(TypedQuery<S> query) {
        if (this.metadata == null) {
            return query;
        }
        LockModeType type = this.metadata.getLockModeType();
        TypedQuery toReturn = type == null ? query : query.setLockMode(type);
        this.applyQueryHints((Query)toReturn);
        return toReturn;
    }

    private void applyQueryHints(Query query) {
        for (Map.Entry hint : this.getQueryHints().withFetchGraphs(this.em)) {
            query.setHint((String)hint.getKey(), hint.getValue());
        }
    }

    private static long executeCountQuery(TypedQuery<Long> query) {
        Assert.notNull(query, (String)"TypedQuery must not be null!");
        List totals = query.getResultList();
        long total = 0L;
        for (Long element : totals) {
            total += element == null ? 0L : element;
        }
        return total;
    }

    private static boolean isUnpaged(Pageable pageable) {
        return pageable.isUnpaged();
    }

    private static class ExampleSpecification<T>
    implements Specification<T> {
        private static final long serialVersionUID = 1L;
        private final Example<T> example;
        private final EscapeCharacter escapeCharacter;

        ExampleSpecification(Example<T> example, EscapeCharacter escapeCharacter) {
            Assert.notNull(example, (String)"Example must not be null!");
            Assert.notNull((Object)escapeCharacter, (String)"EscapeCharacter must not be null!");
            this.example = example;
            this.escapeCharacter = escapeCharacter;
        }

        @Override
        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            return QueryByExamplePredicateBuilder.getPredicate(root, cb, this.example, this.escapeCharacter);
        }
    }

    private static final class ByIdsSpecification<T>
    implements Specification<T> {
        private static final long serialVersionUID = 1L;
        private final JpaEntityInformation<T, ?> entityInformation;
        @Nullable
        ParameterExpression<Collection<?>> parameter;

        ByIdsSpecification(JpaEntityInformation<T, ?> entityInformation) {
            this.entityInformation = entityInformation;
        }

        @Override
        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            Path path = root.get(this.entityInformation.getIdAttribute());
            this.parameter = cb.parameter(Collection.class);
            return path.in(this.parameter);
        }
    }
}

