/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.ConcurrentLruCache;

public final class JdbcUtil {
    public static final SQLType TYPE_UNKNOWN = new SQLType(){

        @Override
        public String getName() {
            return "UNKNOWN";
        }

        @Override
        public String getVendor() {
            return "Spring";
        }

        @Override
        public Integer getVendorTypeNumber() {
            return Integer.MIN_VALUE;
        }

        public String toString() {
            return this.getName();
        }
    };
    private static final Map<Class<?>, SQLType> sqlTypeMappings = new HashMap();
    private static ConcurrentLruCache<Class<?>, SQLType> sqlTypeCache = new ConcurrentLruCache(64, JdbcUtil::doGetSqlType);

    private JdbcUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static SQLType targetSqlTypeFor(Class<?> type) {
        return (SQLType)sqlTypeCache.get(type);
    }

    private static SQLType doGetSqlType(Class<?> type) {
        return sqlTypeMappings.keySet().stream().filter(k -> k.isAssignableFrom(type)).findFirst().map(sqlTypeMappings::get).orElse(TYPE_UNKNOWN);
    }

    static {
        sqlTypeMappings.put(String.class, JDBCType.VARCHAR);
        sqlTypeMappings.put(BigInteger.class, JDBCType.BIGINT);
        sqlTypeMappings.put(BigDecimal.class, JDBCType.DECIMAL);
        sqlTypeMappings.put(Byte.class, JDBCType.TINYINT);
        sqlTypeMappings.put(Byte.TYPE, JDBCType.TINYINT);
        sqlTypeMappings.put(Short.class, JDBCType.SMALLINT);
        sqlTypeMappings.put(Short.TYPE, JDBCType.SMALLINT);
        sqlTypeMappings.put(Integer.class, JDBCType.INTEGER);
        sqlTypeMappings.put(Integer.TYPE, JDBCType.INTEGER);
        sqlTypeMappings.put(Long.class, JDBCType.BIGINT);
        sqlTypeMappings.put(Long.TYPE, JDBCType.BIGINT);
        sqlTypeMappings.put(Double.class, JDBCType.DOUBLE);
        sqlTypeMappings.put(Double.TYPE, JDBCType.DOUBLE);
        sqlTypeMappings.put(Float.class, JDBCType.REAL);
        sqlTypeMappings.put(Float.TYPE, JDBCType.REAL);
        sqlTypeMappings.put(Boolean.class, JDBCType.BIT);
        sqlTypeMappings.put(Boolean.TYPE, JDBCType.BIT);
        sqlTypeMappings.put(byte[].class, JDBCType.VARBINARY);
        sqlTypeMappings.put(Date.class, JDBCType.DATE);
        sqlTypeMappings.put(Time.class, JDBCType.TIME);
        sqlTypeMappings.put(Timestamp.class, JDBCType.TIMESTAMP);
        sqlTypeMappings.put(OffsetDateTime.class, JDBCType.TIMESTAMP_WITH_TIMEZONE);
    }
}

