/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferredConstructor<T, P extends PersistentProperty<P>> {
    private final Constructor<T> constructor;
    private final List<Parameter<Object, P>> parameters;

    public PreferredConstructor(Constructor<T> constructor, Parameter<Object, P> ... parameters) {
        Assert.notNull(constructor);
        Assert.notNull(parameters);
        ReflectionUtils.makeAccessible(constructor);
        this.constructor = constructor;
        this.parameters = Arrays.asList(parameters);
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public Iterable<Parameter<Object, P>> getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public boolean isNoArgConstructor() {
        return this.parameters.isEmpty();
    }

    public boolean isExplicitlyAnnotated() {
        return this.constructor.isAnnotationPresent(PersistenceConstructor.class);
    }

    public boolean isConstructorParameter(PersistentProperty<?> property) {
        Assert.notNull(property);
        for (Parameter<Object, P> parameter : this.parameters) {
            if (!parameter.maps(property)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnclosingClassParameter(Parameter<?, P> parameter) {
        Assert.notNull(parameter);
        if (this.parameters.isEmpty()) {
            return false;
        }
        return this.parameters.get(0).equals(parameter) && ((Parameter)parameter).isEnclosingClassParameter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parameter<T, P extends PersistentProperty<P>> {
        private final String name;
        private final TypeInformation<T> type;
        private final String key;
        private final PersistentEntity<T, P> entity;
        private Boolean enclosingClassCache;

        public Parameter(String name, TypeInformation<T> type, Annotation[] annotations, PersistentEntity<T, P> entity) {
            Assert.notNull(type);
            Assert.notNull((Object)annotations);
            this.name = name;
            this.type = type;
            this.key = this.getValue(annotations);
            this.entity = entity;
        }

        private String getValue(Annotation[] annotations) {
            for (Annotation anno : annotations) {
                if (anno.annotationType() != Value.class) continue;
                return ((Value)anno).value();
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public TypeInformation<T> getType() {
            return this.type;
        }

        public Class<T> getRawType() {
            return this.type.getType();
        }

        public String getSpelExpression() {
            return this.key;
        }

        public boolean hasSpelExpression() {
            return StringUtils.hasText((String)this.getSpelExpression());
        }

        boolean maps(PersistentProperty<?> property) {
            Object referencedProperty = this.entity == null ? null : this.entity.getPersistentProperty(this.name);
            return property == null ? false : property.equals(referencedProperty);
        }

        private boolean isEnclosingClassParameter() {
            if (this.enclosingClassCache == null) {
                Class<T> owningType = this.entity.getType();
                this.enclosingClassCache = owningType.isMemberClass() && this.type.getType().equals(owningType.getEnclosingClass());
            }
            return this.enclosingClassCache;
        }

        public boolean equals(Object obj) {
            boolean nameEquals;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Parameter)) {
                return false;
            }
            Parameter that = (Parameter)obj;
            boolean bl = this.name == null ? that.name == null : (nameEquals = this.name.equals(that.name));
            boolean keyEquals = this.key == null ? that.key == null : this.key.equals(that.key);
            boolean typeEquals = ObjectUtils.nullSafeEquals(this.type, that.type);
            boolean entityEquals = this.entity == null ? that.entity == null : this.entity.equals(that.entity);
            return nameEquals && keyEquals && typeEquals && entityEquals;
        }

        public int hashCode() {
            int result = 17;
            result += 31 * ObjectUtils.nullSafeHashCode((Object)this.name);
            result += 31 * ObjectUtils.nullSafeHashCode((Object)this.key);
            result += 31 * ObjectUtils.nullSafeHashCode(this.type);
            return result += 31 * ObjectUtils.nullSafeHashCode(this.entity);
        }
    }
}

