/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.web.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class TraceGatewayEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Log log = LogFactory.getLog(TraceGatewayEnvironmentPostProcessor.class);
    private static final String PROPERTY_SOURCE_NAME = "defaultProperties";

    TraceGatewayEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.sleuthEnabled(environment) && this.isGatewayOnTheClasspath()) {
            String instrumentationType = environment.getProperty("spring.sleuth.reactor.instrumentation-type");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found the following instrumentation type [" + instrumentationType + "]"));
            }
            if (StringUtils.isEmpty((Object)instrumentationType)) {
                instrumentationType = "manual";
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No instrumentation type passed, will force it to [" + instrumentationType + "]"));
                }
            }
            map.put("spring.sleuth.reactor.instrumentation-type", instrumentationType);
        }
        this.addOrReplace(environment.getPropertySources(), map);
    }

    private boolean sleuthEnabled(ConfigurableEnvironment environment) {
        return Boolean.parseBoolean(environment.getProperty("spring.sleuth.enabled", "true"));
    }

    private boolean isGatewayOnTheClasspath() {
        try {
            ClassUtils.forName((String)"org.springframework.cloud.gateway.filter.GatewayFilter", null);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void addOrReplace(MutablePropertySources propertySources, Map<String, Object> map) {
        PropertySource source;
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME) && (source = propertySources.get(PROPERTY_SOURCE_NAME)) instanceof MapPropertySource) {
            target = (MapPropertySource)source;
            for (String key : map.keySet()) {
                if (target.containsProperty(key)) continue;
                ((Map)target.getSource()).put(key, map.get(key));
            }
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast((PropertySource)target);
        }
    }
}

