/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave;

import brave.TracingCustomizer;
import brave.handler.SpanHandler;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;

final class SamplerCondition
extends AnyNestedCondition {
    SamplerCondition() {
        super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
    }

    static class SpanHandlerOtherThanCompositePresent
    extends SpringBootCondition
    implements ConfigurationCondition {
        SpanHandlerOtherThanCompositePresent() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            boolean moreThanSingleHandler;
            String[] spanHandlers = context.getBeanFactory().getBeanNamesForType(SpanHandler.class);
            boolean bl = moreThanSingleHandler = spanHandlers.length > 1;
            if (moreThanSingleHandler) {
                return ConditionOutcome.match((String)"More than one handler present");
            }
            if (spanHandlers.length == 0) {
                return ConditionOutcome.noMatch((String)"No span handler is available");
            }
            boolean singleCompositeSpanHandler = spanHandlers.length == 1 && spanHandlers[0].equals("traceCompositeSpanHandler");
            return singleCompositeSpanHandler ? ConditionOutcome.noMatch((String)"Composite handler found") : ConditionOutcome.match((String)"Composite handler not found");
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }
    }

    @ConditionalOnBean(value={TracingCustomizer.class})
    static final class TracingCustomizerAvailable {
        TracingCustomizerAvailable() {
        }
    }

    @Conditional(value={SpanHandlerOtherThanCompositePresent.class})
    static final class SpanHandlerAvailable {
        SpanHandlerAvailable() {
        }
    }

    @ConditionalOnBean(type={"zipkin2.reporter.Reporter"})
    static final class ReporterAvailable {
        ReporterAvailable() {
        }
    }
}

