/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.batch.item.database.Order;
import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryUtils;
import org.springframework.util.StringUtils;

public class SqlWindowingPagingQueryProvider
extends AbstractSqlPagingQueryProvider {
    @Override
    public String generateFirstPageQuery(int pageSize) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ( ");
        sql.append("SELECT ").append(StringUtils.hasText((String)this.getOrderedQueryAlias()) ? this.getOrderedQueryAlias() + ".*, " : "*, ");
        sql.append("ROW_NUMBER() OVER (").append(this.getOverClause());
        sql.append(") AS ROW_NUMBER");
        sql.append(this.getOverSubstituteClauseStart());
        sql.append(" FROM ").append(this.getFromClause()).append(this.getWhereClause() == null ? "" : " WHERE " + this.getWhereClause());
        sql.append(this.getGroupClause() == null ? "" : " GROUP BY " + this.getGroupClause());
        sql.append(this.getOverSubstituteClauseEnd());
        sql.append(") ").append(this.getSubQueryAlias()).append("WHERE ").append(this.extractTableAlias()).append("ROW_NUMBER <= ").append(pageSize);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(this));
        return sql.toString();
    }

    protected String getOrderedQueryAlias() {
        return "";
    }

    protected Object getSubQueryAlias() {
        return "AS TMP_SUB ";
    }

    protected Object extractTableAlias() {
        String alias = "" + this.getSubQueryAlias();
        if (StringUtils.hasText((String)alias) && alias.toUpperCase().startsWith("AS")) {
            alias = alias.substring(3).trim() + ".";
        }
        return alias;
    }

    @Override
    public String generateRemainingPagesQuery(int pageSize) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ( ");
        sql.append("SELECT ").append(StringUtils.hasText((String)this.getOrderedQueryAlias()) ? this.getOrderedQueryAlias() + ".*, " : "*, ");
        sql.append("ROW_NUMBER() OVER (").append(this.getOverClause());
        sql.append(") AS ROW_NUMBER");
        sql.append(this.getOverSubstituteClauseStart());
        sql.append(" FROM ").append(this.getFromClause());
        if (this.getWhereClause() != null) {
            sql.append(" WHERE ");
            sql.append(this.getWhereClause());
        }
        sql.append(this.getGroupClause() == null ? "" : " GROUP BY " + this.getGroupClause());
        sql.append(this.getOverSubstituteClauseEnd());
        sql.append(") ").append(this.getSubQueryAlias()).append("WHERE ").append(this.extractTableAlias()).append("ROW_NUMBER <= ").append(pageSize);
        sql.append(" AND ");
        SqlPagingQueryUtils.buildSortConditions(this, sql);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(this));
        return sql.toString();
    }

    @Override
    public String generateJumpToItemQuery(int itemIndex, int pageSize) {
        int page = itemIndex / pageSize;
        int lastRowNum = page * pageSize;
        if (lastRowNum <= 0) {
            lastRowNum = 1;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        this.buildSortKeySelect(sql, this.getSortKeysReplaced(this.extractTableAlias()));
        sql.append(" FROM ( ");
        sql.append("SELECT ");
        this.buildSortKeySelect(sql);
        sql.append(", ROW_NUMBER() OVER (").append(this.getOverClause());
        sql.append(") AS ROW_NUMBER");
        sql.append(this.getOverSubstituteClauseStart());
        sql.append(" FROM ").append(this.getFromClause());
        sql.append(this.getWhereClause() == null ? "" : " WHERE " + this.getWhereClause());
        sql.append(this.getGroupClause() == null ? "" : " GROUP BY " + this.getGroupClause());
        sql.append(this.getOverSubstituteClauseEnd());
        sql.append(") ").append(this.getSubQueryAlias()).append("WHERE ").append(this.extractTableAlias()).append("ROW_NUMBER = ").append(lastRowNum);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(this.getSortKeysReplaced(this.extractTableAlias())));
        return sql.toString();
    }

    private Map<String, Order> getSortKeysReplaced(Object qualifierReplacement) {
        String newQualifier = "" + qualifierReplacement;
        LinkedHashMap<String, Order> sortKeys = new LinkedHashMap<String, Order>();
        for (Map.Entry<String, Order> sortKey : this.getSortKeys().entrySet()) {
            sortKeys.put(sortKey.getKey().replaceFirst("^.*\\.", newQualifier), sortKey.getValue());
        }
        return sortKeys;
    }

    private void buildSortKeySelect(StringBuilder sql) {
        this.buildSortKeySelect(sql, null);
    }

    private void buildSortKeySelect(StringBuilder sql, Map<String, Order> sortKeys) {
        String prefix = "";
        if (sortKeys == null) {
            sortKeys = this.getSortKeys();
        }
        for (Map.Entry<String, Order> sortKey : sortKeys.entrySet()) {
            sql.append(prefix);
            prefix = ", ";
            sql.append(sortKey.getKey());
        }
    }

    protected String getOverClause() {
        StringBuilder sql = new StringBuilder();
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(this));
        return sql.toString();
    }

    protected String getOverSubstituteClauseStart() {
        return "";
    }

    protected String getOverSubstituteClauseEnd() {
        return "";
    }
}

