/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.okhttp;

import java.io.IOException;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownServiceException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.sonar.runner.okhttp.Address;
import org.sonar.runner.okhttp.CertificatePinner;
import org.sonar.runner.okhttp.ConnectionPool;
import org.sonar.runner.okhttp.ConnectionSpec;
import org.sonar.runner.okhttp.Handshake;
import org.sonar.runner.okhttp.HttpUrl;
import org.sonar.runner.okhttp.OkHttpClient;
import org.sonar.runner.okhttp.Protocol;
import org.sonar.runner.okhttp.Request;
import org.sonar.runner.okhttp.Response;
import org.sonar.runner.okhttp.Route;
import org.sonar.runner.okhttp.internal.ConnectionSpecSelector;
import org.sonar.runner.okhttp.internal.Platform;
import org.sonar.runner.okhttp.internal.Util;
import org.sonar.runner.okhttp.internal.Version;
import org.sonar.runner.okhttp.internal.framed.FramedConnection;
import org.sonar.runner.okhttp.internal.http.FramedTransport;
import org.sonar.runner.okhttp.internal.http.HttpConnection;
import org.sonar.runner.okhttp.internal.http.HttpEngine;
import org.sonar.runner.okhttp.internal.http.HttpTransport;
import org.sonar.runner.okhttp.internal.http.OkHeaders;
import org.sonar.runner.okhttp.internal.http.RouteException;
import org.sonar.runner.okhttp.internal.http.Transport;
import org.sonar.runner.okhttp.internal.tls.OkHostnameVerifier;
import org.sonar.runner.okio.BufferedSink;
import org.sonar.runner.okio.BufferedSource;
import org.sonar.runner.okio.Source;

public final class Connection {
    private final ConnectionPool pool;
    private final Route route;
    private Socket socket;
    private Handshake handshake;
    private Protocol protocol;
    private HttpConnection httpConnection;
    private FramedConnection framedConnection;
    private long idleStartTimeNs;
    private int recycleCount;
    private Object owner;

    public Connection(ConnectionPool pool, Route route) {
        this.pool = pool;
        this.route = route;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getOwner() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            return this.owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOwner(Object owner) {
        if (this.isFramed()) {
            return;
        }
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.owner != null) {
                throw new IllegalStateException("Connection already has an owner!");
            }
            this.owner = owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean clearOwner() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.owner == null) {
                return false;
            }
            this.owner = null;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeIfOwnedBy(Object owner) throws IOException {
        if (this.isFramed()) {
            throw new IllegalStateException();
        }
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.owner != owner) {
                return;
            }
            this.owner = null;
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    void connect(int connectTimeout, int readTimeout, int writeTimeout, List<ConnectionSpec> connectionSpecs, boolean connectionRetryEnabled) throws RouteException {
        if (this.protocol != null) {
            throw new IllegalStateException("already connected");
        }
        RouteException routeException = null;
        ConnectionSpecSelector connectionSpecSelector = new ConnectionSpecSelector(connectionSpecs);
        Proxy proxy = this.route.getProxy();
        Address address = this.route.getAddress();
        if (this.route.address.getSslSocketFactory() == null && !connectionSpecs.contains(ConnectionSpec.CLEARTEXT)) {
            throw new RouteException(new UnknownServiceException("CLEARTEXT communication not supported: " + connectionSpecs));
        }
        while (this.protocol == null) {
            try {
                this.socket = proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.HTTP ? address.getSocketFactory().createSocket() : new Socket(proxy);
                this.connectSocket(connectTimeout, readTimeout, writeTimeout, connectionSpecSelector);
            }
            catch (IOException e) {
                Util.closeQuietly(this.socket);
                this.socket = null;
                this.handshake = null;
                this.protocol = null;
                this.httpConnection = null;
                this.framedConnection = null;
                if (routeException == null) {
                    routeException = new RouteException(e);
                } else {
                    routeException.addConnectException(e);
                }
                if (connectionRetryEnabled && connectionSpecSelector.connectionFailed(e)) continue;
                throw routeException;
            }
        }
    }

    private void connectSocket(int connectTimeout, int readTimeout, int writeTimeout, ConnectionSpecSelector connectionSpecSelector) throws IOException {
        this.socket.setSoTimeout(readTimeout);
        Platform.get().connectSocket(this.socket, this.route.getSocketAddress(), connectTimeout);
        if (this.route.address.getSslSocketFactory() != null) {
            this.connectTls(readTimeout, writeTimeout, connectionSpecSelector);
        } else {
            this.protocol = Protocol.HTTP_1_1;
        }
        if (this.protocol == Protocol.SPDY_3 || this.protocol == Protocol.HTTP_2) {
            this.socket.setSoTimeout(0);
            this.framedConnection = new FramedConnection.Builder(this.route.address.uriHost, true, this.socket).protocol(this.protocol).build();
            this.framedConnection.sendConnectionPreface();
        } else {
            this.httpConnection = new HttpConnection(this.pool, this, this.socket);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectTls(int readTimeout, int writeTimeout, ConnectionSpecSelector connectionSpecSelector) throws IOException {
        if (this.route.requiresTunnel()) {
            this.createTunnel(readTimeout, writeTimeout);
        }
        Address address = this.route.getAddress();
        SSLSocketFactory sslSocketFactory = address.getSslSocketFactory();
        boolean success = false;
        SSLSocket sslSocket = null;
        try {
            sslSocket = (SSLSocket)sslSocketFactory.createSocket(this.socket, address.getUriHost(), address.getUriPort(), true);
            ConnectionSpec connectionSpec = connectionSpecSelector.configureSecureSocket(sslSocket);
            if (connectionSpec.supportsTlsExtensions()) {
                Platform.get().configureTlsExtensions(sslSocket, address.getUriHost(), address.getProtocols());
            }
            sslSocket.startHandshake();
            Handshake unverifiedHandshake = Handshake.get(sslSocket.getSession());
            if (!address.getHostnameVerifier().verify(address.getUriHost(), sslSocket.getSession())) {
                X509Certificate cert = (X509Certificate)unverifiedHandshake.peerCertificates().get(0);
                throw new SSLPeerUnverifiedException("Hostname " + address.getUriHost() + " not verified:" + "\n    certificate: " + CertificatePinner.pin(cert) + "\n    DN: " + cert.getSubjectDN().getName() + "\n    subjectAltNames: " + OkHostnameVerifier.allSubjectAltNames(cert));
            }
            address.getCertificatePinner().check(address.getUriHost(), unverifiedHandshake.peerCertificates());
            String maybeProtocol = connectionSpec.supportsTlsExtensions() ? Platform.get().getSelectedProtocol(sslSocket) : null;
            this.socket = sslSocket;
            this.handshake = unverifiedHandshake;
            this.protocol = maybeProtocol != null ? Protocol.get(maybeProtocol) : Protocol.HTTP_1_1;
            success = true;
            if (sslSocket != null) {
                Platform.get().afterHandshake(sslSocket);
            }
            if (success) return;
        }
        catch (AssertionError e) {
            try {
                if (!Util.isAndroidGetsocknameError(e)) throw e;
                throw new IOException((Throwable)((Object)e));
            }
            catch (Throwable throwable) {
                if (sslSocket != null) {
                    Platform.get().afterHandshake(sslSocket);
                }
                if (success) throw throwable;
                Util.closeQuietly(sslSocket);
                throw throwable;
            }
        }
        Util.closeQuietly(sslSocket);
        return;
    }

    private void createTunnel(int readTimeout, int writeTimeout) throws IOException {
        Response response;
        Request tunnelRequest = this.createTunnelRequest();
        HttpConnection tunnelConnection = new HttpConnection(this.pool, this, this.socket);
        tunnelConnection.setTimeouts(readTimeout, writeTimeout);
        HttpUrl url = tunnelRequest.httpUrl();
        String requestLine = "CONNECT " + url.host() + ":" + url.port() + " HTTP/1.1";
        block4: while (true) {
            tunnelConnection.writeRequest(tunnelRequest.headers(), requestLine);
            tunnelConnection.flush();
            response = tunnelConnection.readResponse().request(tunnelRequest).build();
            long contentLength = OkHeaders.contentLength(response);
            if (contentLength == -1L) {
                contentLength = 0L;
            }
            Source body = tunnelConnection.newFixedLengthSource(contentLength);
            Util.skipAll(body, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
            body.close();
            switch (response.code()) {
                case 200: {
                    if (tunnelConnection.bufferSize() > 0L) {
                        throw new IOException("TLS tunnel buffered too many bytes!");
                    }
                    return;
                }
                case 407: {
                    tunnelRequest = OkHeaders.processAuthHeader(this.route.getAddress().getAuthenticator(), response, this.route.getProxy());
                    if (tunnelRequest != null) continue block4;
                    throw new IOException("Failed to authenticate with proxy");
                }
            }
            break;
        }
        throw new IOException("Unexpected response code for CONNECT: " + response.code());
    }

    private Request createTunnelRequest() throws IOException {
        HttpUrl tunnelUrl = new HttpUrl.Builder().scheme("https").host(this.route.address.uriHost).port(this.route.address.uriPort).build();
        return new Request.Builder().url(tunnelUrl).header("Host", Util.hostHeader(tunnelUrl)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", Version.userAgent()).build();
    }

    void connectAndSetOwner(OkHttpClient client, Object owner) throws RouteException {
        this.setOwner(owner);
        if (!this.isConnected()) {
            List<ConnectionSpec> connectionSpecs = this.route.address.getConnectionSpecs();
            this.connect(client.getConnectTimeout(), client.getReadTimeout(), client.getWriteTimeout(), connectionSpecs, client.getRetryOnConnectionFailure());
            if (this.isFramed()) {
                client.getConnectionPool().share(this);
            }
            client.routeDatabase().connected(this.getRoute());
        }
        this.setTimeouts(client.getReadTimeout(), client.getWriteTimeout());
    }

    boolean isConnected() {
        return this.protocol != null;
    }

    public Route getRoute() {
        return this.route;
    }

    public Socket getSocket() {
        return this.socket;
    }

    BufferedSource rawSource() {
        if (this.httpConnection == null) {
            throw new UnsupportedOperationException();
        }
        return this.httpConnection.rawSource();
    }

    BufferedSink rawSink() {
        if (this.httpConnection == null) {
            throw new UnsupportedOperationException();
        }
        return this.httpConnection.rawSink();
    }

    boolean isAlive() {
        return !this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    boolean isReadable() {
        if (this.httpConnection != null) {
            return this.httpConnection.isReadable();
        }
        return true;
    }

    void resetIdleStartTime() {
        if (this.framedConnection != null) {
            throw new IllegalStateException("framedConnection != null");
        }
        this.idleStartTimeNs = System.nanoTime();
    }

    boolean isIdle() {
        return this.framedConnection == null || this.framedConnection.isIdle();
    }

    long getIdleStartTimeNs() {
        return this.framedConnection == null ? this.idleStartTimeNs : this.framedConnection.getIdleStartTimeNs();
    }

    public Handshake getHandshake() {
        return this.handshake;
    }

    Transport newTransport(HttpEngine httpEngine) throws IOException {
        return this.framedConnection != null ? new FramedTransport(httpEngine, this.framedConnection) : new HttpTransport(httpEngine, this.httpConnection);
    }

    boolean isFramed() {
        return this.framedConnection != null;
    }

    public Protocol getProtocol() {
        return this.protocol != null ? this.protocol : Protocol.HTTP_1_1;
    }

    void setTimeouts(int readTimeoutMillis, int writeTimeoutMillis) throws RouteException {
        if (this.protocol == null) {
            throw new IllegalStateException("not connected");
        }
        if (this.httpConnection != null) {
            try {
                this.socket.setSoTimeout(readTimeoutMillis);
            }
            catch (IOException e) {
                throw new RouteException(e);
            }
            this.httpConnection.setTimeouts(readTimeoutMillis, writeTimeoutMillis);
        }
    }

    void incrementRecycleCount() {
        ++this.recycleCount;
    }

    int recycleCount() {
        return this.recycleCount;
    }

    public String toString() {
        return "Connection{" + this.route.address.uriHost + ":" + this.route.address.uriPort + ", proxy=" + this.route.proxy + " hostAddress=" + this.route.inetSocketAddress.getAddress().getHostAddress() + " cipherSuite=" + (this.handshake != null ? this.handshake.cipherSuite() : "none") + " protocol=" + (Object)((Object)this.protocol) + '}';
    }
}

