/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.ScoredGetter;
import org.simpleflatmapper.reflect.ScoredSetter;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ConstructorPropertyMeta;
import org.simpleflatmapper.reflect.meta.OptionalPropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ErrorHelper;

public class OptionalClassMeta<T>
implements ClassMeta<Optional<T>> {
    private final ReflectionService reflectionService;
    private final Type type;
    private final InstantiatorDefinition instantiatorDefinition;
    private final ConstructorPropertyMeta<Optional<T>, ?> propertyMeta;
    private final ClassMeta<T> innerMeta;

    public OptionalClassMeta(ReflectionService reflectionService, Type type, InstantiatorDefinition instantiatorDefinition, ConstructorPropertyMeta<Optional<T>, ?> propertyMeta, ClassMeta<T> innerMeta) {
        this.reflectionService = reflectionService;
        this.type = type;
        this.instantiatorDefinition = instantiatorDefinition;
        this.propertyMeta = propertyMeta;
        this.innerMeta = innerMeta;
    }

    public OptionalClassMeta(Type type, ReflectionService reflectionService) {
        this.type = type;
        this.reflectionService = reflectionService;
        try {
            this.instantiatorDefinition = this.getInstantiatorDefinition(type);
            this.propertyMeta = new ConstructorPropertyMeta("value", type, reflectionService, this.instantiatorDefinition.getParameters()[0], new ScoredGetter(Integer.MAX_VALUE, new OptionalGetter()), ScoredSetter.nullSetter(), this.instantiatorDefinition, null);
            this.innerMeta = reflectionService.getClassMeta(this.instantiatorDefinition.getParameters()[0].getGenericType());
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            throw new IllegalStateException();
        }
    }

    @Override
    public ClassMeta<Optional<T>> withReflectionService(ReflectionService reflectionService) {
        return new OptionalClassMeta(reflectionService, this.type, this.instantiatorDefinition, this.propertyMeta.withReflectionService(reflectionService), reflectionService.getClassMeta(this.innerMeta.getType()));
    }

    private InstantiatorDefinition getInstantiatorDefinition(Type type) throws NoSuchMethodException {
        ParameterizedType pt = (ParameterizedType)type;
        ExecutableInstantiatorDefinition id = new ExecutableInstantiatorDefinition(Optional.class.getMethod("ofNullable", Object.class), new Parameter(0, "value", Object.class, pt.getActualTypeArguments()[0]));
        return id;
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public PropertyFinder<Optional<T>> newPropertyFinder() {
        return new OptionalPropertyFinder(this, this.reflectionService.selfScoreFullName());
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public ClassMeta<T> getInnerMeta() {
        return this.innerMeta;
    }

    public PropertyMeta<Optional<T>, ?> getProperty() {
        return this.propertyMeta;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return Arrays.asList(this.instantiatorDefinition);
    }

    @Override
    public void forEachProperties(Consumer<? super PropertyMeta<Optional<T>, ?>> consumer) {
        consumer.accept(this.propertyMeta);
    }

    @Override
    public int getNumberOfProperties() {
        return 1;
    }

    @Override
    public boolean needTransformer() {
        return false;
    }

    private static class OptionalGetter<T>
    implements Getter<Optional<T>, Object> {
        private OptionalGetter() {
        }

        @Override
        public Object get(Optional<T> target) throws Exception {
            return target.orElse(null);
        }
    }
}

