/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.lightningcsv;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.simpleflatmapper.lightningcsv.CellWriter;
import org.simpleflatmapper.lightningcsv.ClosableCsvWriter;
import org.simpleflatmapper.lightningcsv.CsvCellWriter;

public class CsvWriter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final CellWriter cellWriter;
    private final Appendable appendable;
    private boolean rowHasData = false;

    public CsvWriter(CellWriter cellWriter, Appendable appendable) {
        this.cellWriter = cellWriter;
        this.appendable = appendable;
    }

    public final CsvWriter appendCell(CharSequence charSequence) throws IOException {
        return this.appendCell(charSequence, 0, charSequence.length());
    }

    public final CsvWriter appendCell(CharSequence charSequence, int start, int end) throws IOException {
        CellWriter cellWriter = this.cellWriter;
        Appendable appendable = this.appendable;
        if (this.rowHasData) {
            cellWriter.nextCell(appendable);
        }
        cellWriter.writeValue(charSequence, start, end, appendable);
        this.rowHasData = true;
        return this;
    }

    public final CsvWriter appendCell(char[] chars) throws IOException {
        return this.appendCell(chars, 0, chars.length);
    }

    public final CsvWriter appendCell(char[] chars, int start, int end) throws IOException {
        CellWriter cellWriter = this.cellWriter;
        Appendable appendable = this.appendable;
        if (this.rowHasData) {
            cellWriter.nextCell(appendable);
        }
        cellWriter.writeValue(chars, start, end, appendable);
        this.rowHasData = true;
        return this;
    }

    public final CsvWriter endOfRow() throws IOException {
        this.cellWriter.endOfRow(this.appendable);
        this.rowHasData = false;
        return this;
    }

    public final CsvWriter appendRow(CharSequence ... values) throws IOException {
        CellWriter cellWriter = this.cellWriter;
        Appendable appendable = this.appendable;
        if (values != null && values.length > 0) {
            if (this.rowHasData) {
                cellWriter.nextCell(appendable);
            }
            cellWriter.writeValue(values[0], appendable);
            for (int i = 1; i < values.length; ++i) {
                cellWriter.nextCell(appendable);
                cellWriter.writeValue(values[i], appendable);
            }
        }
        cellWriter.endOfRow(appendable);
        this.rowHasData = false;
        return this;
    }

    public final CsvWriter appendRow(Iterable<? extends CharSequence> values) throws IOException {
        Iterator<? extends CharSequence> iterator;
        CellWriter cellWriter = this.cellWriter;
        Appendable appendable = this.appendable;
        if (values != null && (iterator = values.iterator()).hasNext()) {
            if (this.rowHasData) {
                cellWriter.nextCell(appendable);
            }
            cellWriter.writeValue(iterator.next(), appendable);
            while (iterator.hasNext()) {
                cellWriter.nextCell(appendable);
                cellWriter.writeValue(iterator.next(), appendable);
            }
        }
        cellWriter.endOfRow(appendable);
        this.rowHasData = false;
        return this;
    }

    public static DSL dsl() {
        return DSL.INSTANCE;
    }

    public static final class DSL {
        private static final DSL INSTANCE = new DSL();
        private final boolean alwaysEscape;
        private final char separator;
        private final char quote;
        private final char escape;
        private final String endOfLine;

        private DSL() {
            this(',', '\"', '\"', false, "\r\n");
        }

        private DSL(char separator, char quote, char escape, boolean alwaysEscape, String endOfLine) {
            this.separator = separator;
            this.quote = quote;
            this.escape = escape;
            this.alwaysEscape = alwaysEscape;
            this.endOfLine = endOfLine;
        }

        public DSL separator(char separator) {
            return new DSL(separator, this.quote, this.escape, this.alwaysEscape, this.endOfLine);
        }

        public DSL quote(char quote) {
            return new DSL(this.separator, quote, this.escape, this.alwaysEscape, this.endOfLine);
        }

        public DSL escape(char escape) {
            return new DSL(this.separator, this.quote, escape, this.alwaysEscape, this.endOfLine);
        }

        public DSL alwaysEscape(boolean alwaysEscape) {
            return new DSL(this.separator, this.quote, this.escape, alwaysEscape, this.endOfLine);
        }

        public DSL endOfLine(String endOfLine) {
            return new DSL(this.separator, this.quote, this.escape, this.alwaysEscape, endOfLine);
        }

        public DSL alwaysEscape() {
            return this.alwaysEscape(true);
        }

        public ClosableCsvWriter to(Path path) throws IOException {
            return this.to(path, UTF_8);
        }

        public ClosableCsvWriter to(Path path, Charset charset) throws IOException {
            return new ClosableCsvWriter((CellWriter)new CsvCellWriter(this.separator, this.quote, this.escape, this.alwaysEscape, this.endOfLine), this.getWriter(path, charset));
        }

        private Writer getWriter(Path path, Charset charset) throws IOException {
            return Files.newBufferedWriter(path, charset, new OpenOption[0]);
        }

        public ClosableCsvWriter to(File file) throws IOException {
            return this.to(file, UTF_8);
        }

        public ClosableCsvWriter to(File file, Charset charset) throws IOException {
            return new ClosableCsvWriter((CellWriter)new CsvCellWriter(this.separator, this.quote, this.escape, this.alwaysEscape, this.endOfLine), this.getWriter(file, charset));
        }

        private Writer getWriter(File file, Charset charset) throws IOException {
            return this.getWriter(file.toPath(), charset);
        }

        public CsvWriter to(Appendable appendable) {
            return new CsvWriter(new CsvCellWriter(this.separator, this.quote, this.escape, this.alwaysEscape, this.endOfLine), appendable);
        }
    }
}

