package org.sharengo.wikitty.search;

// Start of user code for import

import java.io.Serializable;

// End of user code  for import

/**
 * <!-- Start of user code for Not -->
 * 
 * <p>
 * Not operator is used to build negative restriction for request on content.
 * <br>
 * <br>
 * For example, use: RestrictionHelper.not( RestrictionHelper.eq( myElement ,
 * "myValue" ) )
 * </p>
 * 
 * <!-- End of user code for Not -->
 */
public class Not extends Restriction implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    protected Restriction restriction;

    /**
     * Default constructor
     */
    public Not() {
        super();
    }

    /**
     * Constructor with all parameters initialized
     * 
     * @param restriction
     */
    public Not(Restriction restriction) {
        this.restriction = restriction;
    }

    /**
     * Return restriction
     * 
     * @return
     */
    public Restriction getRestriction() {
        return restriction;
    }

    /**
     * Set a value to parameter restriction.
     * 
     * @param restriction
     */
    public void setRestriction(Restriction restriction) {
        this.restriction = restriction;
    }

    /**
     * Equality test based attributes values
     * 
     * @param value
     *            Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Not)) {
            return false;
        }

        final Not not = (Not) other;

        if ((restriction == null && not.getRestriction() != null)
                || (restriction != null && !restriction.equals(not
                        .getRestriction())))
            return false;

        return true;
    }

    public int hashCode() {
        int result = Not.class.getName().hashCode();
        if (restriction != null) {
            result = 29 * result + restriction.hashCode();
        }
        return result;
    }

}