/* *##%
 * Copyright (c) 2009 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty;

import java.util.Collection;
import java.util.List;

/**
 * WikittyStorage is used to abstract data and extension storage in WikittyService.
 *
 * @author poussin
 * @version $Revision: 1 $
 *
 * Last update: $Date: 2010-04-16 10:29:38 +0200 (ven., 16 avril 2010) $
 * by : $Author: echatellier $
 */
public interface WikittyStorage {

    /**
     * Store wikitty in storage
     * @return information usefull for client side update data
     */
    public UpdateResponse store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement);

    /**
     * Return true if id exists in storage
     * @param id
     * @return
     */
    public boolean exists(WikittyTransaction transaction, String id);

    /**
     * Return true if wikitty object with this id are marked deleted
     * @param id
     * @return
     */
    public boolean isDeleted(WikittyTransaction transaction, String id);

    /**
     * Restore list of wikitty object, if wikitty not found an exception is throw
     * @param id list of wikitty id
     * @param fqFieldName list of field that must be loaded, other fields
     * can be not loaded
     * @return
     */
    public Wikitty restore(WikittyTransaction transaction, String id,
            String ... fqFieldName) throws WikittyException;

    /**
     * Delete all object with id argument. If id is not valid or don't exist
     * throw an exception
     * @param idList
     * @return
     */
    public UpdateResponse delete(WikittyTransaction transaction, Collection<String> idList) throws WikittyException;

    /**
     * Scan all wikitties with specific scanner, even if the wikitty is deleted
     * @param scanner scanner
     */
    void scanWikitties(WikittyTransaction transaction, Scanner scanner);

    /**
     * Call each time wikitty is scan
     */
    public static interface Scanner {
        void scan(Wikitty wikitty);
    }

    /**
     * Remove all wikitty
     */
    public void clear(WikittyTransaction transaction);

}
